#version 330 core

uniform mat4 ModelViewProjectionMatrix;
uniform mat4 ModelViewMatrixInverse;
uniform mat3 NormalMatrix;
uniform sampler2D pincushion_coord;

in vec3 POSITION;
in vec3 NORMAL;
in vec2 TEXCOORD;

out vec3 normal;
out vec2 uv;
out vec2 pos_zw;


#include <pincushion/pincushion_include.vert>


void main()
{
	vec2 offset, depth_uv;
	getPincushionOffsetUV(offset, depth_uv);

	vec3 pos = POSITION + vec3(offset, 0.0);

#if 0
	float d = texture(pincushion_coord, depth_uv).z;
#else
	float d = bilinear_sampling(pincushion_coord, depth_uv).z;
#endif
	if ( pos.z > 0.0 && d > 0.0 )
	{
		pos.z += d;
	}

	uv = TEXCOORD;
	normal = NormalMatrix * NORMAL;

	vec4 proj_pos = ModelViewProjectionMatrix * vec4(pos, 1.0);
	pos_zw = proj_pos.zw;
	gl_Position = proj_pos;
}
