#version 330 core

uniform sampler2D diffuse;
//uniform sampler2D specular;

in vec3 normal;
in vec2 uv;
in vec2 pos_zw;
in float intensity;

layout (location = 0) out vec4 diffuse_specular;
layout (location = 1) out vec4 normal_depth;

void main()
{
	diffuse_specular.rgb = texture(diffuse, uv).rgb * intensity;
	diffuse_specular.a = intensity; //texture(specular, uv).r;

	normal_depth.xyz = normalize( normal );
	normal_depth.w = pos_zw.x/pos_zw.y;
}
