#version 330 core

uniform sampler2D diffuse_specular;
uniform sampler2D normal_depth;
uniform sampler2D depth;
uniform sampler2D proj_tex;
uniform vec2 viewport;

uniform mat4 TextureMatrix;

in vec3 spot_pos;
in vec3 spot_dir;
in vec3 spot_params; // cone_angle, cone_cutoff_angle, radius
in vec3 spot_color;  // rgb*intensity

layout (location = 0) out vec4 frag_color;

#include <deferred/gbuffer_include.frag>

#include <shading_model/blinn_phong_model_include.frag>

void main()
{
	vec2 uv = gl_FragCoord.xy * viewport;
	vec4 ds = texture(diffuse_specular, uv);
	vec4 nd = texture(normal_depth, uv);

	vec3 pos = calc_position(uv, nd.w);

	vec3 ld = spot_pos - pos;
	float len = length(ld);
	if ( len > spot_params.z ) discard;

	ld = normalize(ld);

	vec3 n = normalize(nd.xyz);
	vec3 ed = normalize(-pos);

	float atten = 1.0 - (len / spot_params.z);
	atten *= clamp( (dot(-ld, spot_dir) - spot_params.x) / (spot_params.y - spot_params.x), 0.0, 1.0 );
	vec3 terms = calculate_blinn_phong_model(n, ld, ed, 8.0)*atten;

	vec4 tpos = TextureMatrix * vec4(pos, 1.0);
	vec3 color = textureProj(proj_tex, tpos).xyz * spot_color * float(tpos.w < 0.0);
	
	frag_color.rgb = color*ds.rgb*terms.x + color*ds.a*terms.y;
	frag_color.a = 0.0;
}
