/*
 * Decompiled with CFR 0.152.
 */
package test;

import gameobjects.Item;
import gameobjects.map.ItemTypes;
import gameobjects.map.Map;
import io.MapLoader;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.newdawn.slick.SlickException;

public class TestMapLoader {
    private String mapPath = "src/resources/images";

    @Test
    public void loadMaps() throws IOException, SlickException {
        Item item = new Item(ItemTypes.BLUE_GEM);
        Map map = MapLoader.loadMap(new File("src/resources/maps/e1l1.gem"));
        Assert.assertEquals((Object)"Untitled", (Object)map.getName());
        Assert.assertEquals((Object)"Unknown", (Object)map.getCreator());
        Assert.assertEquals((long)23L, (long)map.getWidth());
        Assert.assertEquals((long)11L, (long)map.getHeight());
        Assert.assertEquals((long)65L, (long)map.getTime());
        Assert.assertEquals((long)9L, (long)map.getGemCount());
        Assert.assertEquals((Object)((Object)ItemTypes.METAL_WALL), (Object)((Object)map.getGroundLayer().getTile((int)0, (int)0).itemType));
        Assert.assertEquals((Object)((Object)ItemTypes.METAL_WALL), (Object)((Object)map.getGroundLayer().getTile((int)1, (int)0).itemType));
        Assert.assertEquals((Object)((Object)ItemTypes.METAL_WALL), (Object)((Object)map.getGroundLayer().getTile((int)3, (int)0).itemType));
        Assert.assertEquals((Object)((Object)ItemTypes.METAL_WALL), (Object)((Object)map.getGroundLayer().getTile((int)4, (int)0).itemType));
        Assert.assertEquals((Object)((Object)ItemTypes.METAL_WALL), (Object)((Object)map.getGroundLayer().getTile((int)5, (int)0).itemType));
        Assert.assertEquals((Object)((Object)ItemTypes.METAL_WALL), (Object)((Object)map.getGroundLayer().getTile((int)6, (int)0).itemType));
        Assert.assertEquals((Object)((Object)ItemTypes.METAL_WALL), (Object)((Object)map.getGroundLayer().getTile((int)7, (int)0).itemType));
        Assert.assertEquals((Object)((Object)ItemTypes.METAL_WALL), (Object)((Object)map.getGroundLayer().getTile((int)22, (int)10).itemType));
        Assert.assertEquals((Object)((Object)ItemTypes.BROWN_WALL), (Object)((Object)map.getGroundLayer().getTile((int)2, (int)2).itemType));
    }

    @Test
    public void testCollisionInitialization() {
        Map map = new Map();
        map.createCollision(1000, 1000);
        int i = 0;
        while (i < 1000) {
            int j = 0;
            while (j < 1000) {
                Assert.assertFalse((boolean)map.isColliding(i, j));
                ++j;
            }
            ++i;
        }
    }

    @Test
    public void testFindingMaps() {
        List<File> files = MapLoader.findAvailableMaps(new File("src/resources/maps/"));
        Assert.assertTrue((boolean)files.contains(new File("src\\resources\\maps\\e1l1.gem")));
        Assert.assertTrue((boolean)files.contains(new File("src\\resources\\maps\\e1l2.gem")));
        Assert.assertTrue((boolean)files.contains(new File("src\\resources\\maps\\e1l3.gem")));
        Assert.assertTrue((boolean)files.contains(new File("src\\resources\\maps\\e1l4.gem")));
        Assert.assertTrue((boolean)files.contains(new File("src\\resources\\maps\\e2l1.gem")));
        Assert.assertTrue((boolean)files.contains(new File("src\\resources\\maps\\e2l2.gem")));
        Assert.assertTrue((boolean)files.contains(new File("src\\resources\\maps\\e2l3.gem")));
        Assert.assertTrue((boolean)files.contains(new File("src\\resources\\maps\\e2l4.gem")));
        Assert.assertTrue((boolean)files.contains(new File("src\\resources\\maps\\e3l1.gem")));
        Assert.assertTrue((boolean)files.contains(new File("src\\resources\\maps\\e3l2.gem")));
        Assert.assertTrue((boolean)files.contains(new File("src\\resources\\maps\\e3l3.gem")));
        Assert.assertTrue((boolean)files.contains(new File("src\\resources\\maps\\e3l4.gem")));
        Assert.assertTrue((boolean)files.contains(new File("src\\resources\\maps\\e4l1.gem")));
        Assert.assertTrue((boolean)files.contains(new File("src\\resources\\maps\\e4l2.gem")));
        Assert.assertTrue((boolean)files.contains(new File("src\\resources\\maps\\e4l3.gem")));
        Assert.assertTrue((boolean)files.contains(new File("src\\resources\\maps\\e4l4.gem")));
        Assert.assertTrue((boolean)files.contains(new File("src\\resources\\maps\\e5l1.gem")));
        Assert.assertTrue((boolean)files.contains(new File("src\\resources\\maps\\e5l2.gem")));
        Assert.assertTrue((boolean)files.contains(new File("src\\resources\\maps\\e5l3.gem")));
        Assert.assertTrue((boolean)files.contains(new File("src\\resources\\maps\\e5l4.gem")));
        Assert.assertTrue((boolean)files.contains(new File("src\\resources\\maps\\e6l1.gem")));
        Assert.assertTrue((boolean)files.contains(new File("src\\resources\\maps\\race1.gem")));
    }
}

