/*
 * Decompiled with CFR 0.152.
 */
package io;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.newdawn.slick.Animation;
import org.newdawn.slick.Color;
import org.newdawn.slick.Image;
import org.newdawn.slick.Music;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.Sound;
import org.newdawn.slick.SpriteSheet;
import org.newdawn.slick.loading.LoadingList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ResourceManager {
    private static String SPRITE_SHEET_REF = "__SPRITE_SHEET_";
    private static ResourceManager _instance = new ResourceManager();
    private Map<String, Sound> soundMap = new HashMap<String, Sound>();
    private Map<String, Music> musicMap = new HashMap<String, Music>();
    private Map<String, Image> imageMap = new HashMap<String, Image>();
    private Map<String, ResourceAnimationData> animationMap = new HashMap<String, ResourceAnimationData>();
    private Map<String, String> textMap = new HashMap<String, String>();

    private ResourceManager() {
    }

    public static final ResourceManager getInstance() {
        return _instance;
    }

    public void loadResources(InputStream is) throws SlickException {
        this.loadResources(is, false);
    }

    public void loadResources(InputStream is, boolean deferred) throws SlickException {
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = null;
        try {
            docBuilder = docBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new SlickException("Could not load resources", (Throwable)e);
        }
        Document doc = null;
        try {
            doc = docBuilder.parse(is);
        }
        catch (SAXException e) {
            throw new SlickException("Could not load resources", (Throwable)e);
        }
        catch (IOException e) {
            throw new SlickException("Could not load resources", (Throwable)e);
        }
        doc.getDocumentElement().normalize();
        NodeList listResources = doc.getElementsByTagName("resource");
        int totalResources = listResources.getLength();
        if (deferred) {
            LoadingList.setDeferredLoading((boolean)true);
        }
        int resourceIdx = 0;
        while (resourceIdx < totalResources) {
            Node resourceNode = listResources.item(resourceIdx);
            if (resourceNode.getNodeType() == 1) {
                Element resourceElement = (Element)resourceNode;
                String type = resourceElement.getAttribute("type");
                if (type.equals("image")) {
                    this.addElementAsImage(resourceElement);
                } else if (type.equals("sound")) {
                    this.addElementAsSound(resourceElement);
                } else if (type.equals("music")) {
                    this.addElementAsMusic(resourceElement);
                } else if (type.equals("text")) {
                    this.addElementAsText(resourceElement);
                } else if (!type.equals("font") && type.equals("animation")) {
                    this.addElementAsAnimation(resourceElement);
                }
            }
            ++resourceIdx;
        }
    }

    private void addElementAsAnimation(Element resourceElement) throws SlickException {
        this.loadAnimation(resourceElement.getAttribute("id"), resourceElement.getTextContent(), Integer.valueOf(resourceElement.getAttribute("tw")), Integer.valueOf(resourceElement.getAttribute("th")), Integer.valueOf(resourceElement.getAttribute("duration")));
    }

    private void loadAnimation(String id, String spriteSheetPath, int tw, int th, int duration) throws SlickException {
        if (spriteSheetPath == null || spriteSheetPath.length() == 0) {
            throw new SlickException("Image resource [" + id + "] has invalid path");
        }
        this.loadImage(String.valueOf(SPRITE_SHEET_REF) + id, spriteSheetPath, null);
        this.animationMap.put(id, new ResourceAnimationData(String.valueOf(SPRITE_SHEET_REF) + id, tw, th, duration));
    }

    public final Animation getAnimation(String ID) {
        ResourceAnimationData rad = this.animationMap.get(ID);
        SpriteSheet spr = new SpriteSheet(this.getImage(rad.getImageId()), rad.tw, rad.th);
        Animation animation = new Animation(spr, rad.duration);
        return animation;
    }

    private void addElementAsText(Element resourceElement) throws SlickException {
        this.loadText(resourceElement.getAttribute("id"), resourceElement.getTextContent());
    }

    public String loadText(String id, String value) throws SlickException {
        if (value == null) {
            throw new SlickException("Text resource [" + id + "] has invalid value");
        }
        this.textMap.put(id, value);
        return value;
    }

    public String getText(String ID) {
        return this.textMap.get(ID);
    }

    private void addElementAsSound(Element resourceElement) throws SlickException {
        this.loadSound(resourceElement.getAttribute("id"), resourceElement.getTextContent());
    }

    public Sound loadSound(String id, String path) throws SlickException {
        if (path == null || path.length() == 0) {
            throw new SlickException("Sound resource [" + id + "] has invalid path");
        }
        Sound sound = null;
        try {
            sound = new Sound(path);
        }
        catch (SlickException e) {
            throw new SlickException("Could not load sound", (Throwable)e);
        }
        this.soundMap.put(id, sound);
        return sound;
    }

    public final Sound getSound(String ID) {
        return this.soundMap.get(ID);
    }

    private void addElementAsMusic(Element resourceElement) throws SlickException {
        this.loadMusic(resourceElement.getAttribute("id"), resourceElement.getTextContent());
    }

    public Music loadMusic(String id, String path) throws SlickException {
        if (path == null || path.length() == 0) {
            throw new SlickException("Music resource [" + id + "] has invalid path");
        }
        Music music = null;
        try {
            music = new Music(path);
        }
        catch (SlickException e) {
            throw new SlickException("Could not load music", (Throwable)e);
        }
        this.musicMap.put(id, music);
        return music;
    }

    public final Music getMusic(String ID) {
        return this.musicMap.get(ID);
    }

    private final void addElementAsImage(Element resourceElement) throws SlickException {
        this.loadImage(resourceElement.getAttribute("id"), resourceElement.getTextContent(), resourceElement.getAttribute("filter"));
    }

    public static Sound fetchSound(String id) {
        return ResourceManager.getInstance().getSound(id);
    }

    public static Music fetchMusic(String id) {
        return ResourceManager.getInstance().getMusic(id);
    }

    public static Animation fetchAnimation(String id) {
        return ResourceManager.getInstance().getAnimation(id);
    }

    public static Image fetchImage(String id) {
        return ResourceManager.getInstance().getImage(id);
    }

    public Image loadImage(String id, String path, String transparentColor) throws SlickException {
        if (path == null || path.length() == 0) {
            throw new SlickException("Image resource [" + id + "] has invalid path");
        }
        Integer filterValue = null;
        try {
            if (transparentColor != null && transparentColor.length() > 0) {
                Long value = Long.parseLong(transparentColor, 16);
                filterValue = value.intValue();
            }
        }
        catch (NumberFormatException e) {
            throw new SlickException("Can't parse image filter color number. Resource ID " + id, (Throwable)e);
        }
        Image image = null;
        try {
            if (filterValue != null) {
                Color color = new Color(filterValue.intValue());
                image = new Image(path, color);
            } else {
                image = new Image(path);
            }
        }
        catch (SlickException e) {
            throw new SlickException("Could not load image", (Throwable)e);
        }
        this.imageMap.put(id, image);
        return image;
    }

    public final Image getImage(String ID) {
        return this.imageMap.get(ID);
    }

    private class ResourceAnimationData {
        int duration;
        int tw;
        int th;
        String imageId;

        public ResourceAnimationData(String id, int tw, int th, int duration) {
            this.imageId = id;
            this.tw = tw;
            this.th = th;
            this.duration = duration;
        }

        public final int getDuration() {
            return this.duration;
        }

        public final void setDuration(int duration) {
            this.duration = duration;
        }

        public final int getTw() {
            return this.tw;
        }

        public final void setTw(int tw) {
            this.tw = tw;
        }

        public final int getTh() {
            return this.th;
        }

        public final void setTh(int th) {
            this.th = th;
        }

        public final String getImageId() {
            return this.imageId;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }
    }
}

