/*
 * Decompiled with CFR 0.152.
 */
package gemwars.ui.components;

import gameobjects.IGameObject;
import io.ResourceManager;
import java.util.ArrayList;
import org.newdawn.slick.Color;
import org.newdawn.slick.Font;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;
import org.newdawn.slick.Input;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.UnicodeFont;
import org.newdawn.slick.geom.Rectangle;
import org.newdawn.slick.geom.Shape;
import org.newdawn.slick.util.InputAdapter;

public class Button
extends InputAdapter
implements IGameObject {
    protected String buttonName;
    protected Image buttonImg;
    protected Shape shape;
    protected float textOffsetX = 0.0f;
    protected float textOffsetY = 0.0f;
    protected Color filterColor;
    protected String buttonText;
    protected float mouseX = 0.0f;
    protected float mouseY = 0.0f;
    private ArrayList<ButtonListener> listeners = new ArrayList();
    private UnicodeFont font;
    private FilterColor filterColorInUse;

    public Button(String buttonName, String text, float x, float y) throws SlickException {
        this.buttonName = buttonName;
        float padding = 5.0f;
        this.buttonImg = ResourceManager.getInstance().getImage("BUTTON_UP");
        this.shape = new Rectangle(x, y, (float)this.buttonImg.getWidth() + padding * 2.0f, (float)this.buttonImg.getHeight() + padding * 2.0f);
        this.buttonText = text;
        this.filterColor = new Color(1.0f, 1.0f, 1.0f, 1.0f);
        this.filterColorInUse = FilterColor.GREEN;
        this.centerizeText();
    }

    public Button(String buttonName, String text, Image buttonImg, Shape rectangle) throws SlickException {
        this.buttonName = buttonName;
        this.shape = rectangle;
        this.buttonText = text;
        this.buttonImg = buttonImg;
        this.filterColor = new Color(1.0f, 1.0f, 1.0f, 1.0f);
        this.centerizeText();
    }

    public Button() {
        this.buttonText = "";
        this.filterColor = new Color(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public Button(String buttonName, String text, Image buttonImg, Shape rectangle, float textOffsetX, float textOffsetY) throws SlickException {
        this(buttonName, text, buttonImg, rectangle);
        this.textOffsetX = textOffsetX;
        this.textOffsetY = textOffsetY;
    }

    public float getWidth() {
        return this.shape.getWidth();
    }

    public String getButtonText() {
        return this.buttonText;
    }

    public void setFilterColor(FilterColor color) {
        this.filterColorInUse = color;
    }

    public Color getFilterColor() {
        return this.filterColor;
    }

    public void setX(float x) {
        this.shape.setX(x);
    }

    public void setY(float y) {
        this.shape.setY(y);
    }

    public float getHeight() {
        return this.shape.getHeight();
    }

    public void setPosition(float x, float y) {
        this.shape.setX(x);
        this.shape.setY(y);
        this.centerizeText();
    }

    public void setTextOffsetX(float textOffsetX) {
        this.textOffsetX = textOffsetX;
    }

    public void setTextOffsetY(float textOffsetY) {
        this.textOffsetY = textOffsetY;
    }

    public void centerizeText() {
        this.textOffsetX = (this.getWidth() - (float)this.font.getWidth(this.buttonText)) / 2.0f;
        this.textOffsetY = (this.getHeight() - (float)this.font.getHeight(this.buttonText)) / 2.0f;
        System.out.println(String.valueOf(this.buttonText) + " " + this.textOffsetX + this.font.getHeight(this.buttonText));
    }

    public float getTextOffsetY() {
        return this.textOffsetY;
    }

    public float getTextOffsetX() {
        return this.textOffsetX;
    }

    private boolean isMouseOver(float x, float y) {
        return this.shape.contains(x, y);
    }

    @Override
    public void render(GameContainer cont, Graphics g) throws SlickException {
        this.buttonImg.draw(this.shape.getX(), this.shape.getY(), this.shape.getWidth(), this.shape.getHeight(), this.filterColor);
        g.setFont((Font)this.font);
        g.drawString(this.buttonText, this.shape.getX() + this.textOffsetX, this.shape.getY() + this.textOffsetY);
    }

    @Override
    public void update(GameContainer cont, int delta) throws SlickException {
        Input input = cont.getInput();
        this.mouseX = input.getMouseX();
        this.mouseY = input.getMouseY();
        this.updateFilterColor(this.mouseX, this.mouseY, delta, this.filterColor);
    }

    private void updateFilterColor(float x, float y, int delta, Color filterColor) {
        float stepSize = 0.005f;
        if (this.filterColorInUse == FilterColor.RED) {
            if (this.isMouseOver(this.mouseX, this.mouseY)) {
                if ((double)filterColor.b >= 0.1) {
                    filterColor.b -= stepSize * (float)delta;
                    filterColor.g -= stepSize * (float)delta;
                }
            } else if (filterColor.b < 1.0f) {
                filterColor.b += stepSize * (float)delta;
                filterColor.g += stepSize * (float)delta;
            }
        } else if (this.filterColorInUse == FilterColor.GREEN) {
            if (this.isMouseOver(this.mouseX, this.mouseY)) {
                if ((double)filterColor.r >= 0.1) {
                    filterColor.b -= stepSize * (float)delta;
                    filterColor.r -= stepSize * (float)delta;
                }
            } else if (filterColor.r < 1.0f) {
                filterColor.r += stepSize * (float)delta;
                filterColor.b += stepSize * (float)delta;
            }
        }
    }

    protected void fireButtonPressed(int mousebutton) {
        for (ButtonListener l : this.listeners) {
            l.buttonPressed(new ButtonEvent(this.buttonName, mousebutton));
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof Button) {
            Button btn = (Button)obj;
            if (btn.buttonName.equals(this.buttonName)) {
                return true;
            }
        }
        return false;
    }

    public void addListener(ButtonListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ButtonListener listener) {
        this.listeners.remove(listener);
    }

    public void mousePressed(int button, int x, int y) {
        if (this.isMouseOver(this.mouseX, this.mouseY)) {
            this.fireButtonPressed(button);
        }
    }

    public class ButtonEvent {
        private String buttonName;
        private int mouseButton;

        public ButtonEvent(String buttonName, int mouseButton) {
            this.buttonName = buttonName;
            this.mouseButton = mouseButton;
        }

        public String getButtoName() {
            return this.buttonName;
        }

        public int getMouseButton() {
            return this.mouseButton;
        }
    }

    public static interface ButtonListener {
        public void buttonPressed(ButtonEvent var1);
    }

    public static enum FilterColor {
        RED,
        GREEN;

    }
}

