/*
 * Decompiled with CFR 0.152.
 */
package gemwars;

import gameobjects.GearPair;
import gameobjects.Player;
import java.awt.Color;
import java.util.ArrayList;
import org.newdawn.slick.Font;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Input;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.UnicodeFont;
import org.newdawn.slick.font.effects.GradientEffect;
import org.newdawn.slick.geom.Vector2f;
import org.newdawn.slick.state.BasicGameState;
import org.newdawn.slick.state.StateBasedGame;
import org.newdawn.slick.state.transition.FadeInTransition;
import org.newdawn.slick.state.transition.FadeOutTransition;
import org.newdawn.slick.state.transition.Transition;

public class ConfigurationMenuState
extends BasicGameState {
    private Player player;
    private int stateID;
    private ArrayList<GearPair> gearPairs = new ArrayList();
    private UnicodeFont font;

    public ConfigurationMenuState(int id) {
        this.stateID = id;
    }

    public void init(GameContainer cont, StateBasedGame state) throws SlickException {
        this.gearPairs.add(new GearPair(30.0f, new Vector2f(100.0f, 100.0f), 0.5f));
        this.gearPairs.add(new GearPair(10.0f, new Vector2f(50.0f, 50.0f), 0.3f));
        this.gearPairs.add(new GearPair(15.0f, new Vector2f(400.0f, 350.0f), 0.1f));
        this.gearPairs.add(new GearPair(20.0f, new Vector2f(380.0f, 200.0f), 0.6f));
        this.gearPairs.add(new GearPair(12.0f, new Vector2f(380.0f, 500.0f), 1.0f));
        this.gearPairs.add(new GearPair(5.0f, new Vector2f(500.0f, 600.0f), 0.7f));
        this.gearPairs.add(new GearPair(14.0f, new Vector2f(780.0f, 100.0f), 0.3f));
        this.gearPairs.add(new GearPair(25.0f, new Vector2f(680.0f, 200.0f), 0.2f));
        java.awt.Font awtFont = new java.awt.Font("Ariel", 0, 20);
        this.font = new UnicodeFont(awtFont);
        this.font.addAsciiGlyphs();
        Color topColor = new Color(255);
        Color bottomColor = new Color(0xBBFF00);
        this.font.getEffects().add(new GradientEffect(topColor, bottomColor, 1.0f));
        this.font.loadGlyphs();
        this.player = new Player();
    }

    public int getID() {
        return this.stateID;
    }

    public void enter(GameContainer container, StateBasedGame game) throws SlickException {
        super.enter(container, game);
    }

    public void render(GameContainer cont, StateBasedGame state, Graphics g) throws SlickException {
        g.setBackground(org.newdawn.slick.Color.white);
        g.setFont((Font)this.font);
        for (GearPair pair : this.gearPairs) {
            pair.render(cont, g);
        }
        g.drawString("To return to the main menu, try to press the 'Escape'-key", 50.0f, 50.0f);
        this.player.render(cont, g);
    }

    public void update(GameContainer cont, StateBasedGame state, int delta) throws SlickException {
        for (GearPair pair : this.gearPairs) {
            pair.update(cont, delta);
        }
        Input input = cont.getInput();
        if (input.isKeyPressed(1)) {
            state.enterState(0, (Transition)new FadeOutTransition(), (Transition)new FadeInTransition());
        }
    }
}

