/*
 * Decompiled with CFR 0.152.
 */
package gameobjects.map;

import gameobjects.AEntity;
import gameobjects.Direction;
import gameobjects.Gem;
import gameobjects.Item;
import gameobjects.Monster;
import gameobjects.Player;
import gameobjects.map.ItemTypes;
import gameobjects.map.Layer;
import gameobjects.map.LayerTypes;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.util.Log;

public class Map
extends AEntity {
    private String filename;
    private int width;
    private int height;
    private String name;
    private String creator;
    private int gemCount;
    private int time;
    private boolean[][] collisionLayer;
    private Layer groundLayer;
    private Layer specialLayer;
    private Layer objectLayer;
    private List<Player> players = new ArrayList<Player>();
    private List<Monster> monsters = new ArrayList<Monster>();
    private double cameraPositionX = 0.0;
    private double cameraPositionY = 0.0;
    private boolean goalOpen = false;

    @Override
    public void render(GameContainer cont, Graphics graph) throws SlickException {
        graph.translate((float)this.cameraPositionX, (float)this.cameraPositionY);
        this.groundLayer.render(cont, graph);
        this.specialLayer.render(cont, graph);
        this.objectLayer.render(cont, graph);
        for (Player player : this.players) {
            player.render(cont, graph);
        }
        for (Monster m : this.monsters) {
            m.render(cont, graph);
        }
        graph.resetTransform();
    }

    @Override
    public void update(GameContainer cont, int delta) throws SlickException {
        this.objectLayer.update(cont, delta);
        for (Player player : this.players) {
            player.update(cont, delta);
        }
        Player p = this.players.get(0);
        if (p.direction != Direction.STATIONARY) {
            this.centerCameraToPlayer(cont, p);
        }
        ArrayList<Monster> newMonsters = new ArrayList<Monster>();
        for (Monster m : this.monsters) {
            if (!m.isDead()) {
                newMonsters.add(m);
            }
            m.update(cont, delta);
        }
        this.monsters = newMonsters;
        if (!this.goalOpen && this.players.get(0).getGems() >= this.gemCount) {
            this.openGoal();
        }
    }

    private void openGoal() {
        this.goalOpen = true;
        List<Point> goals = this.findItemPositions(this.specialLayer, ItemTypes.GOAL);
        Point p = goals.get(0);
        this.setCollision(p.x, p.y, false);
        Item i = new Item(ItemTypes.GOAL_TILE);
        i.positionX = p.x;
        i.positionY = p.y;
        this.groundLayer.setTile(p.x, p.y, i);
    }

    private void centerCameraToPlayer(GameContainer cont, Player p) {
        this.cameraPositionX = -1 * p.positionX * 56 + cont.getWidth() / 2 - 28;
        this.cameraPositionY = -1 * p.positionY * 56 + cont.getHeight() / 2 - 28;
        if (p.direction == Direction.DOWN) {
            this.cameraPositionY -= p.getDistance();
        }
        if (p.direction == Direction.UP) {
            this.cameraPositionY += p.getDistance();
        }
        if (p.direction == Direction.LEFT) {
            this.cameraPositionX += p.getDistance();
        }
        if (p.direction == Direction.RIGHT) {
            this.cameraPositionX -= p.getDistance();
        }
    }

    public void initPlayers() {
        this.initPlayers(null);
    }

    public void initPlayers(List<Player> players) {
        if (players == null) {
            for (Point startingPosition : this.getStartingPositions()) {
                Log.debug((String)("Creating player to position: " + startingPosition));
                Player player = new Player(startingPosition.x, startingPosition.y, this);
                this.players.add(player);
            }
            return;
        }
        for (Player p : players) {
            for (Point startingPosition : this.getStartingPositions()) {
                this.players.clear();
                this.players.add(p);
                p.positionX = startingPosition.x;
                p.positionY = startingPosition.y;
            }
        }
    }

    public List<Point> getStartingPositions() {
        return this.findItemPositions(this.specialLayer, ItemTypes.START);
    }

    public List<Point> findEndingPoint() {
        return this.findItemPositions(this.specialLayer, ItemTypes.GOAL);
    }

    public List<Point> findItemPositions(Layer layer, ItemTypes type) {
        ArrayList<Point> positions = new ArrayList<Point>();
        int x = 0;
        while (x < this.specialLayer.getWidth()) {
            int y = 0;
            while (y < this.specialLayer.getHeight()) {
                if (this.specialLayer.tiles[x][y].itemType == type) {
                    positions.add(new Point(x, y));
                }
                ++y;
            }
            ++x;
        }
        return positions;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public int getTime() {
        return this.time;
    }

    public void setTime(int time) {
        this.time = time;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setGemCount(int gems) {
        this.gemCount = gems;
    }

    public int getGemCount() {
        return this.gemCount;
    }

    public void createCollision(int layerWidth, int layerHeight) {
        this.collisionLayer = new boolean[layerHeight][layerWidth];
        this.setWidth(layerWidth);
        this.setHeight(layerHeight);
    }

    public void setCollision(int x, int y, boolean b) {
        this.collisionLayer[y][x] = b;
    }

    public boolean isColliding(int x, int y) {
        if (this.objectLayer.getTile((int)x, (int)y).itemType != ItemTypes.BLUE_GEM && this.objectLayer.getTile((int)x, (int)y).itemType != ItemTypes.RED_GEM && this.objectLayer.getTile((int)x, (int)y).itemType != ItemTypes.GREEN_GEM && this.objectLayer.getTile((int)x, (int)y).itemType != ItemTypes.EMPTY) {
            return true;
        }
        if (x >= 0 && x < this.collisionLayer[y].length && y >= 0 && y < this.collisionLayer.length) {
            return this.collisionLayer[y][x];
        }
        return true;
    }

    public boolean isTileContainingGem(int x, int y) {
        Item item = this.objectLayer.getTile(x, y);
        return item.itemType == ItemTypes.RED_GEM || item.itemType == ItemTypes.BLUE_GEM || item.itemType == ItemTypes.GREEN_GEM;
    }

    public boolean isTileContainingDirt(int x, int y) {
        Item item = this.groundLayer.getTile(x, y);
        return item.itemType == ItemTypes.SAND;
    }

    public boolean destroyDirt(int x, int y) {
        if (this.isTileContainingDirt(x, y)) {
            Item item = new Item(ItemTypes.GROUND);
            this.groundLayer.setTile(x, y, item);
            return true;
        }
        return false;
    }

    public void destroyGem(int x, int y) {
        if (this.isTileContainingGem(x, y)) {
            this.objectLayer.setTile(x, y, new Item(ItemTypes.EMPTY));
        }
    }

    public boolean isMonsterColliding(int x, int y) {
        if (this.groundLayer.getTile((int)x, (int)y).itemType != ItemTypes.GROUND) {
            return true;
        }
        if (this.objectLayer.getTile((int)x, (int)y).itemType == ItemTypes.BLUE_GEM) {
            return true;
        }
        if (this.objectLayer.getTile((int)x, (int)y).itemType == ItemTypes.RED_GEM) {
            return true;
        }
        if (this.objectLayer.getTile((int)x, (int)y).itemType == ItemTypes.GREEN_GEM) {
            return true;
        }
        if (this.objectLayer.getTile((int)x, (int)y).itemType == ItemTypes.DARK_BOULDER) {
            return true;
        }
        if (this.objectLayer.getTile((int)x, (int)y).itemType == ItemTypes.WHITE_BOULDER) {
            return true;
        }
        if (this.specialLayer.getTile((int)x, (int)y).itemType != ItemTypes.EMPTY) {
            return true;
        }
        if (x >= 0 && x < this.collisionLayer[y].length && y >= 0 && y < this.collisionLayer.length) {
            return this.collisionLayer[y][x];
        }
        return true;
    }

    public boolean setLayer(Layer l) {
        if (l.getType() == LayerTypes.LAYER_GROUND.ordinal()) {
            this.groundLayer = l;
            return true;
        }
        if (l.getType() == LayerTypes.LAYER_OBJECTS.ordinal()) {
            this.objectLayer = l;
            return true;
        }
        if (l.getType() == LayerTypes.LAYER_SPECIAL.ordinal()) {
            this.specialLayer = l;
            return true;
        }
        return false;
    }

    public Layer getGroundLayer() {
        return this.groundLayer;
    }

    public Layer getSpecialLayer() {
        return this.specialLayer;
    }

    public Layer getObjectLayer() {
        return this.objectLayer;
    }

    public void enter(GameContainer cont) {
        this.centerCameraToPlayer(cont, this.players.get(0));
        for (Player p : this.players) {
            p.setDead(false);
        }
    }

    public Player getPlayer(int number) {
        return this.players.get(number);
    }

    public void add(Monster monster) {
        this.monsters.add(monster);
    }

    public List<Player> getPlayers() {
        return this.players;
    }

    public boolean hasPlayerDied(Player player) {
        for (Monster m : this.monsters) {
            if (m.positionX != player.positionX || m.positionY != player.positionY) continue;
            return true;
        }
        return false;
    }

    public void drawDiamondMatrix(int posX, int posY) throws SlickException {
        int x = posX - 1;
        while (x <= posX + 1) {
            int y = posY - 1;
            while (y <= posY + 1) {
                if (!this.isColliding(x, y)) {
                    Gem g = new Gem(ItemTypes.RED_GEM);
                    Item i = new Item(ItemTypes.GROUND);
                    g.positionX = x;
                    g.positionY = y;
                    i.positionX = x;
                    i.positionY = y;
                    this.groundLayer.setTile(x, y, i);
                    this.objectLayer.setTile(x, y, g);
                }
                ++y;
            }
            ++x;
        }
    }

    public List<Monster> getMonsters() {
        return this.monsters;
    }

    public boolean isGoalOpen() {
        return this.goalOpen;
    }
}

