/*
 * Decompiled with CFR 0.152.
 */
package gameobjects.map;

import gameobjects.AEntity;
import gameobjects.Item;
import gameobjects.map.ItemTypes;
import gameobjects.map.LayerTypes;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.SlickException;

public class Layer
extends AEntity {
    private int width = 0;
    private int height = 0;
    public Item[][] tiles;
    private LayerTypes layerType;

    public Layer(int width, int height, LayerTypes type) {
        this.width = width;
        this.height = height;
        this.layerType = type;
        this.tiles = new Item[width][height];
        int x = 0;
        while (x < width) {
            int y = 0;
            while (y < height) {
                this.tiles[x][y] = new Item(ItemTypes.EMPTY);
                ++y;
            }
            ++x;
        }
    }

    public void setTile(int posX, int posY, Item tile) {
        tile.positionX = posX;
        tile.positionY = posY;
        this.tiles[posX][posY] = tile;
    }

    @Override
    public void render(GameContainer cont, Graphics grap) throws SlickException {
        int x = 0;
        while (x < this.width) {
            int y = 0;
            while (y < this.height) {
                this.tiles[x][y].render(cont, grap);
                ++y;
            }
            ++x;
        }
    }

    @Override
    public void update(GameContainer cont, int delta) throws SlickException {
        int x = 0;
        while (x < this.width) {
            int y = 0;
            while (y < this.height) {
                this.tiles[x][y].update(cont, delta);
                ++y;
            }
            ++x;
        }
    }

    public Item getTile(int x, int y) {
        return this.tiles[x][y];
    }

    public int getType() {
        return this.layerType.layerIndex();
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }
}

