/*
 * Decompiled with CFR 0.152.
 */
package gameobjects;

import gameobjects.AEntity;
import gameobjects.Direction;
import gameobjects.Gem;
import gameobjects.map.Map;
import io.Options;
import io.ResourceManager;
import java.awt.Point;
import org.newdawn.slick.Animation;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;
import org.newdawn.slick.Input;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.Sound;

public class Player
extends AEntity {
    private static int __staticPlayerNumber = 0;
    public int playerNumber = __staticPlayerNumber++;
    public int lives = 3;
    public int score;
    public int collectedGemCount;
    boolean areWeMoving = false;
    private double distance;
    private Sound gemCollectedSound;
    private Image stationary;
    private Image stationaryTemp;
    private Animation walkingRight;
    private Animation walkingLeft;
    private Animation walkingUp;
    private Animation walkingDown;
    private Animation pushLeft;
    private Animation pushRight;
    private Image deadImage;
    private Map map;
    private boolean dead = false;
    public boolean pushingStone = false;

    public Player() {
        this.postProcessAnimations();
        this.initSounds();
    }

    public Player(int positionX, int positionY) {
        this();
        this.positionX = positionX;
        this.positionY = positionY;
        this.speed = 0.1;
    }

    public Player(int posX, int posY, Map map) {
        this(posX, posY);
        this.map = map;
    }

    private void initSounds() {
        this.gemCollectedSound = ResourceManager.fetchSound("GAME_COLLECT");
    }

    @Override
    public void render(GameContainer cont, Graphics grap) throws SlickException {
        int drawX = this.positionX * 56;
        int drawY = this.positionY * 56;
        if (this.direction == Direction.UP) {
            grap.drawAnimation(this.walkingUp, (float)drawX, (float)((int)((double)drawY - this.distance)));
        }
        if (this.direction == Direction.DOWN) {
            grap.drawAnimation(this.walkingDown, (float)drawX, (float)((int)((double)drawY + this.distance)));
        }
        if (this.direction == Direction.LEFT) {
            grap.drawAnimation(this.walkingLeft, (float)((int)((double)drawX - this.distance)), (float)drawY);
        }
        if (this.direction == Direction.RIGHT) {
            grap.drawAnimation(this.walkingRight, (float)((int)((double)drawX + this.distance)), (float)drawY);
        }
        if (this.direction == Direction.STATIONARY) {
            grap.drawImage(this.stationaryTemp, (float)drawX, (float)drawY);
        }
    }

    @Override
    public void update(GameContainer cont, int delta) throws SlickException {
        Input input = cont.getInput();
        if (!this.dead) {
            if (this.direction == Direction.STATIONARY) {
                if (input.isKeyDown(208) && !this.map.isColliding(this.positionX, this.positionY + 1)) {
                    this.direction = Direction.DOWN;
                }
                if (input.isKeyDown(200) && !this.map.isColliding(this.positionX, this.positionY - 1)) {
                    this.direction = Direction.UP;
                }
                if (input.isKeyDown(203) && !this.map.isColliding(this.positionX - 1, this.positionY)) {
                    this.direction = Direction.LEFT;
                }
                if (input.isKeyDown(205) && !this.map.isColliding(this.positionX + 1, this.positionY)) {
                    this.direction = Direction.RIGHT;
                }
                this.stationaryTemp = this.stationary;
            }
            if (this.direction != Direction.STATIONARY && this.distance <= 56.0) {
                this.distance += this.speed * (double)delta;
            } else {
                if (this.direction == Direction.LEFT) {
                    --this.positionX;
                    this.stationaryTemp = this.walkingLeft.getCurrentFrame();
                }
                if (this.direction == Direction.RIGHT) {
                    ++this.positionX;
                    this.stationaryTemp = this.walkingRight.getCurrentFrame();
                }
                if (this.direction == Direction.UP) {
                    --this.positionY;
                    this.stationaryTemp = this.walkingUp.getCurrentFrame();
                }
                if (this.direction == Direction.DOWN) {
                    ++this.positionY;
                    this.stationaryTemp = this.walkingDown.getCurrentFrame();
                }
                this.distance = 0.0;
                this.direction = Direction.STATIONARY;
            }
            this.collectDiamonds();
            this.dig();
        }
    }

    private void dig() {
        Point point = Direction.scanDirection(this.direction);
        this.map.destroyDirt(this.positionX + point.x, this.positionY + point.y);
    }

    private void collectDiamonds() {
        Point point = Direction.scanDirection(this.direction);
        boolean isCollected = this.map.isTileContainingGem(this.positionX + point.x, this.positionY + point.y);
        if (isCollected && this.map.getObjectLayer().getTile((int)(this.positionX + point.x), (int)(this.positionY + point.y)).direction == Direction.STATIONARY) {
            this.score += ((Gem)this.map.getObjectLayer().getTile(this.positionX + point.x, this.positionY + point.y)).getValue();
            ++this.collectedGemCount;
            this.gemCollectedSound.play(1.0f, Options.getInstance().getSoundVolume());
            this.map.destroyGem(this.positionX + point.x, this.positionY + point.y);
        }
    }

    private void postProcessAnimations() {
        this.walkingRight = ResourceManager.getInstance().getAnimation("PLAYER_RIGHT");
        this.walkingLeft = ResourceManager.getInstance().getAnimation("PLAYER_LEFT");
        this.walkingUp = ResourceManager.getInstance().getAnimation("PLAYER_UP");
        this.walkingDown = ResourceManager.getInstance().getAnimation("PLAYER_DOWN");
        this.pushRight = ResourceManager.getInstance().getAnimation("PLAYER_PUSH_RIGHT");
        this.pushLeft = ResourceManager.getInstance().getAnimation("PLAYER_PUSH_LEFT");
        this.stationaryTemp = this.stationary = this.walkingDown.getImage(0);
        this.deadImage = ResourceManager.fetchImage("ITEM_TEXTURES").getSubImage(0, 0, 56, 56);
    }

    public double getDistance() {
        return this.distance;
    }

    public int getScore() {
        return this.score;
    }

    public int getGems() {
        return this.collectedGemCount;
    }

    public int getLives() {
        return this.lives;
    }

    public void kill() {
        --this.lives;
        this.dead = true;
    }

    public void setDead(boolean b) {
        this.dead = b;
    }

    public boolean isDead() {
        return this.dead;
    }
}

