/*
 * Decompiled with CFR 0.152.
 */
package gameobjects;

import gameobjects.AEntity;
import gameobjects.map.ItemTypes;
import io.ResourceManager;
import io.Resources;
import java.util.HashMap;
import java.util.Map;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;

public class Item
extends AEntity {
    private static Map<ItemTypes, Image> itemTextures = new HashMap<ItemTypes, Image>();
    public ItemTypes itemType;
    public static final int TILE_WIDTH = 56;
    public static final int TILE_HEIGHT = 56;

    public Item(ItemTypes itemType) {
        this.itemType = itemType;
        if (itemTextures.size() == 0) {
            ResourceManager manager = ResourceManager.getInstance();
            Image textures = manager.getImage(Resources.ITEM_TEXTURES.name());
            ItemTypes[] itemTypesArray = ItemTypes.values();
            int n = itemTypesArray.length;
            int n2 = 0;
            while (n2 < n) {
                ItemTypes type = itemTypesArray[n2];
                if (textures != null) {
                    Image texture = textures.getSubImage(56 * type.ordinal(), 0, 56, 56);
                    itemTextures.put(type, texture);
                }
                ++n2;
            }
        }
    }

    @Override
    public void render(GameContainer cont, Graphics grap) throws SlickException {
        itemTextures.get((Object)this.itemType).draw((float)(this.positionX * 56), (float)(this.positionY * 56));
    }

    @Override
    public void update(GameContainer cont, int delta) throws SlickException {
    }
}

