/*
 * Decompiled with CFR 0.152.
 */
package gameobjects;

import gameobjects.Direction;
import gameobjects.IDynamic;
import gameobjects.Item;
import gameobjects.Monster;
import gameobjects.Player;
import gameobjects.map.ItemTypes;
import gameobjects.map.Map;
import io.ResourceManager;
import org.newdawn.slick.Animation;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;
import org.newdawn.slick.Renderable;
import org.newdawn.slick.SlickException;
import utils.GemwarsUtils;

public class Boulder
extends Item
implements IDynamic {
    private Image staticStone;
    private Animation falling;
    private Animation movingLeft;
    private Animation movingRight;
    private Renderable currentAnimation;
    private double distance;
    private Direction lastDirection;
    private Map map;

    public Boulder(ItemTypes boulderType, Map map) throws SlickException {
        super(boulderType);
        this.map = map;
        this.init();
        this.speed = 0.1;
    }

    private void init() throws SlickException {
        if (this.itemType == ItemTypes.WHITE_BOULDER) {
            this.falling = ResourceManager.fetchAnimation("ROCK_WHITE_DOWN");
            this.movingRight = ResourceManager.fetchAnimation("ROCK_WHITE_RIGHT");
            this.movingLeft = GemwarsUtils.reverseAnimation(this.movingRight);
        } else if (this.itemType == ItemTypes.DARK_BOULDER) {
            this.falling = ResourceManager.fetchAnimation("ROCK_DARK_DOWN");
            this.movingRight = ResourceManager.fetchAnimation("ROCK_DARK_RIGHT");
            this.movingLeft = GemwarsUtils.reverseAnimation(this.movingRight);
        } else {
            throw new SlickException("Invalid item type can boulder be this kinda? ItemType." + this.itemType.name());
        }
        this.staticStone = this.falling.getImage(0);
    }

    @Override
    public boolean isPushable() {
        return true;
    }

    @Override
    public boolean isPhysicsAffected() {
        return true;
    }

    @Override
    public void render(GameContainer cont, Graphics grap) throws SlickException {
        int drawX = this.positionX * 56;
        int drawY = this.positionY * 56;
        if (this.direction == Direction.STATIONARY) {
            this.staticStone.draw((float)drawX, (float)drawY);
        }
        if (this.direction == Direction.DOWN) {
            this.falling.draw((float)drawX, (float)((int)((double)(drawY - 56) + this.distance)));
        }
        if (this.direction == Direction.LEFT) {
            this.movingLeft.draw((float)((int)((double)(drawX + 56) - this.distance)), (float)drawY);
        }
        if (this.direction == Direction.RIGHT) {
            this.movingRight.draw((float)((int)((double)(drawX - 56) + this.distance)), (float)drawY);
        }
    }

    public boolean isFalling() {
        return this.canDrop(this.positionX, this.positionY + 1);
    }

    public boolean isRollingRight() {
        return this.canDrop(this.positionX + 1, this.positionY + 1) && this.canDrop(this.positionX + 1, this.positionY);
    }

    public boolean isRollingLeft() {
        return this.canDrop(this.positionX - 1, this.positionY + 1) && this.canDrop(this.positionX - 1, this.positionY);
    }

    public boolean canDrop(int x, int y) {
        if (this.map.getGroundLayer().getTile((int)x, (int)y).itemType == ItemTypes.GROUND) {
            if (this.map.getObjectLayer().getTile((int)x, (int)y).itemType != ItemTypes.EMPTY) {
                return false;
            }
            for (Player p : this.map.getPlayers()) {
                if (!(p.positionX == x && p.positionY == y || p.direction == Direction.LEFT && p.positionX == x + 1 && p.positionY == y || p.direction == Direction.RIGHT && p.positionX == x - 1 && p.positionY == y) && (p.direction != Direction.UP || p.positionX != x || p.positionY != y + 1)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public void update(GameContainer cont, int delta) throws SlickException {
        if (this.direction != Direction.STATIONARY && this.distance <= 56.0) {
            this.distance += this.speed * (double)delta;
        } else {
            this.distance = 0.0;
            this.lastDirection = this.direction;
            this.direction = Direction.STATIONARY;
            if (this.isFalling()) {
                this.direction = Direction.DOWN;
                this.map.getObjectLayer().setTile(this.positionX, this.positionY, new Item(ItemTypes.EMPTY));
                ++this.positionY;
                this.map.getObjectLayer().setTile(this.positionX, this.positionY, this);
                for (Player p : this.map.getPlayers()) {
                    if (p.positionX != this.positionX || p.positionY != this.positionY) continue;
                    p.kill();
                }
                for (Monster m : this.map.getMonsters()) {
                    if (m.positionX != this.positionX || m.positionY != this.positionY) continue;
                    m.kill();
                }
            } else if (this.lastDirection == Direction.DOWN && this.isRollingRight()) {
                this.direction = Direction.RIGHT;
                this.map.getObjectLayer().setTile(this.positionX, this.positionY, new Item(ItemTypes.EMPTY));
                ++this.positionX;
                this.map.getObjectLayer().setTile(this.positionX, this.positionY, this);
            } else if (this.lastDirection == Direction.DOWN && this.isRollingLeft()) {
                this.direction = Direction.LEFT;
                this.map.getObjectLayer().setTile(this.positionX, this.positionY, new Item(ItemTypes.EMPTY));
                --this.positionX;
                this.map.getObjectLayer().setTile(this.positionX, this.positionY, this);
            } else {
                this.direction = Direction.STATIONARY;
            }
        }
    }
}

