package Ragedemo01;

import processing.core.PApplet;
import processing.core.*;

/**
 * A class for printing a text on the parent program's screen.
 * 
 * @author RageManifesto
 * @version 001
 *
 */
public class RageTexter extends PApplet {

	private PApplet parent;
	private PFont font;
	private String text;
	private float xpos;
	private float ypos;
	private float xmovement;
	private float ymovement;
	private int[] color;
	private float alpha = 0f;
	private float alphaChange = 0f;
	
	RageTexter(PApplet p, String text, String font, int size, float xpos, float ypos, float xmovement, float ymovement, int[] color, int initialAlpha) {
		
		this.parent = p;
		this.font = createFont(font, size);
		this.text = text;
		this.xpos = xpos;
		this.ypos = ypos;
		this.xmovement = xmovement;
		this.ymovement = ymovement;
		this.color = color;
		this.alpha = initialAlpha;
	}
	
	
	public void draw() {
		
		xpos += xmovement;
		ypos += ymovement;
		
		parent.textFont(font);
		alpha += alphaChange;
		if ( alpha > 255.0f ) {
			alpha = 255.0f;
			alphaChange = 0.0f;
		}
		if ( alpha < 0.0f ) {
			alpha = 0.0f;
			alphaChange = 0.0f;
		}
		parent.fill(color[0], color[1], color[2], alpha);
	    parent.text(text, xpos, ypos);
	}
	
	
	public float fade(float amount) {
		this.alphaChange = amount;
		return this.alpha;
	}
	
	
	
}
