package Ragedemo01;

import processing.core.PApplet;


/**
 * Draws a cartoon-like cloud that glides through the parent program's screen.
 * Hardcoded for 1280x720
 * 
 * 
 * @version 001
 * @author Rage Manifesto
 *
 */
public class RageClouds extends PApplet {

	private PApplet parent;
	private float posX;
	private float posY;
	private float speed;
	private float pieceSize;
	private int pieceAmount;
	private int[] coord_x;
	private int[] coord_y;
	private float[] pieceSizeInputModifier;
	
	
	RageClouds(PApplet p, float initialPos_x, float initialPos_y, float speed, float pieceSize, int cloudPieces) {
		
		this.parent = p;
		this.posX = initialPos_x;
		this.posY = initialPos_y;
		this.speed = speed;
		this.pieceSize = pieceSize;
		this.pieceAmount = cloudPieces;
		
		this.coord_x = new int[cloudPieces];
		this.coord_y = new int[cloudPieces];
		this.pieceSizeInputModifier = new float[cloudPieces];
			
		for ( int i = 0; i < cloudPieces; i++ ) {
			this.coord_x[i] = (int)(parent.random(-120f, 120f));
			this.coord_y[i] = (int)(parent.random(-20f, 20f));
			this.pieceSizeInputModifier[i] = parent.random(-30f, 30f);
			
		}
		
	}
	
	
	public void draw() {
		
		posX += speed;
		if (posX < -200 ) posX = 1480; //FIXME: for next version, get rid of this hardcodedness
		float psiz;
		
		parent.fill(225, 225, 225);
		parent.noStroke();
		//parent.strokeWeight(2);
		
		parent.ellipse(posX, posY, pieceSize, pieceSize);
		for ( int i = 0; i < pieceAmount; i++ ) {
			pieceSizeInputModifier[i] += 0.015f;
			psiz = (float) (pieceSize + Math.sin(pieceSizeInputModifier[i])*15);
			parent.ellipse(posX + coord_x[i], posY + coord_y[i], psiz, psiz);
		}
		
	}
	
	


}
