/*
 * Decompiled with CFR 0.152.
 */
package Ragedemo01;

import processing.core.PApplet;

public class RageBoxes
extends PApplet {
    private PApplet parent;
    private Item[] items;
    private float nextDistance;

    public RageBoxes(PApplet p, int itemAmount, float distance, boolean isLooping, boolean isFilled, boolean isStroke, int alpha, int[] strokeColor_rgb) {
        this.parent = p;
        this.initialize(itemAmount, distance, isLooping, isFilled, isStroke, alpha, strokeColor_rgb);
    }

    public RageBoxes(PApplet p) {
        this.parent = p;
        this.initialize(500, -10.0f, false, true, true, 255, new int[3]);
    }

    private void initialize(int itemAmount, float distance, boolean isLooping, boolean isFilled, boolean isStroke, int alpha, int[] strokeColor_rgb) {
        this.nextDistance = distance;
        this.items = new Item[itemAmount];
        int i = 0;
        while (i < itemAmount) {
            this.items[i] = new Item(this.parent, this.nextDistance, isLooping, isFilled, isStroke, alpha, strokeColor_rgb);
            this.nextDistance = (float)((double)this.nextDistance - 4.0);
            ++i;
        }
    }

    public void reset(int itemAmount, float distance, boolean isLooping, boolean isFilled, boolean isStroke, int alpha, int[] strokeColor_rgb) {
        this.items = null;
        this.initialize(itemAmount, distance, isLooping, isFilled, isStroke, alpha, strokeColor_rgb);
    }

    public void update() {
    }

    public void draw() {
        int i = 0;
        while (i < this.items.length) {
            this.items[i].draw();
            ++i;
        }
    }

    private class Item {
        private PApplet parent;
        private float a;
        private float xspeed;
        private float yspeed;
        private float xpos;
        private float ypos;
        private float distance;
        private float[] boxMeasures;
        private int[] color_rgb;
        private float rotationModifier;
        private int alpha;
        private boolean isRespawning;
        private boolean isFilled;
        private boolean isStroke;
        private int[] strokeColor_rgb;

        public Item(PApplet p, float distance, boolean isLooping, boolean isFilled, boolean isStroke, int alpha, int[] strokeColor_rgb) {
            this.parent = p;
            this.strokeColor_rgb = strokeColor_rgb;
            this.a = this.parent.random(0.0f, 25.0f);
            this.xspeed = this.parent.random(-5.0f, 25.0f);
            this.yspeed = this.parent.random(12.0f, 25.0f);
            this.distance = distance;
            this.xpos = this.parent.random(-400.0f, 800.0f) + distance * 0.8f;
            this.ypos = this.parent.random(-1000.0f, -800.0f) + distance * 0.8f;
            this.boxMeasures = new float[]{this.parent.random(30.0f, 150.0f), this.parent.random(30.0f, 150.0f), this.parent.random(30.0f, 150.0f)};
            this.color_rgb = new int[]{(int)this.parent.random(10.0f, 255.0f), (int)this.parent.random(10.0f, 255.0f), (int)this.parent.random(10.0f, 255.0f)};
            this.rotationModifier = this.parent.random(-10.0f, 10.0f);
            this.alpha = alpha;
            this.isRespawning = isLooping;
            this.isFilled = isFilled;
            this.isStroke = isStroke;
        }

        public void draw() {
            this.a += 1.0f;
            this.xpos += this.xspeed;
            this.ypos += this.yspeed;
            if (this.isRespawning && (double)this.ypos > 1500.0 + (double)Math.abs(this.distance) * 0.45) {
                this.xpos = this.parent.random(-400.0f, 800.0f) + this.distance * 0.8f;
                this.ypos = this.parent.random(-1000.0f, -800.0f) + this.distance * 0.8f;
                this.color_rgb = new int[]{(int)this.parent.random(10.0f, 255.0f), (int)this.parent.random(10.0f, 255.0f), (int)this.parent.random(10.0f, 255.0f)};
                this.rotationModifier = this.parent.random(-10.0f, 10.0f);
            }
            this.parent.pushMatrix();
            this.parent.translate(this.xpos, this.ypos, this.distance);
            this.parent.rotateX(this.a * ((float)Math.PI * 2) / 360.0f * this.rotationModifier);
            this.parent.rotateY(this.a * ((float)Math.PI * 2) / 360.0f * this.rotationModifier);
            this.parent.rotateZ(this.a * ((float)Math.PI * 2) / 360.0f * this.rotationModifier);
            if (this.isFilled) {
                this.parent.fill((float)this.color_rgb[0], (float)this.color_rgb[1], (float)this.color_rgb[2], (float)this.alpha);
            } else {
                this.parent.noFill();
            }
            if (this.isStroke) {
                this.parent.stroke((float)this.strokeColor_rgb[0], (float)this.strokeColor_rgb[1], (float)this.strokeColor_rgb[2], (float)this.alpha);
                this.parent.strokeWeight(4.0f);
            } else {
                this.parent.noStroke();
            }
            this.parent.box(this.boxMeasures[0], this.boxMeasures[1], this.boxMeasures[2]);
            this.parent.popMatrix();
        }
    }
}

