// simple vertex shader
varying vec4 normal;
uniform float x,y,z;

uniform int uvmode;

vec4 rotateAroundX( float angle, vec4 v )
{
	float sa = sin( angle );
	float ca = cos( angle );

	return vec4( v.x,
				 ca*v.y - sa*v.z,
				 sa*v.y + ca*v.z,
				 v.w );
}


vec4 rotateAroundY( float angle, vec4 v )
{
	float sa = sin( angle );
	float ca = cos( angle );

	return vec4( sa*v.z + ca*v.x,   v.y,
				 ca*v.z - sa*v.x,   v.w );
}

//---------

vec4 rotateAroundZ( float angle, vec4 v )
{
	float sa = sin( angle );
	float ca = cos( angle );

	return vec4( ca*v.x - sa*v.y,
				 sa*v.x + ca*v.y,
				 v.z, v.w );
}
vec4 pos;
void main()
{

	pos=(gl_MultiTexCoord0*1.0);
	if(uvmode==1)
	{
	pos.x=sin(gl_MultiTexCoord0.x*6.2831)*gl_MultiTexCoord0.y;
	pos.y=cos(gl_MultiTexCoord0.x*6.2831)*gl_MultiTexCoord0.y;
	}
	gl_Position    =gl_ModelViewProjectionMatrix*pos; 
	//gl_Position    = gl_MultiTexCoord0*vec4(2,2.2,1,1)+vec4(-1,-1.1,0,0);
	gl_FrontColor  = gl_Color;
	gl_TexCoord[0] = gl_MultiTexCoord0;
	normal=vec4(normalize(gl_Normal),0);
	normal=rotateAroundX(x,normal);
	normal=rotateAroundY(y,normal);
	normal=rotateAroundZ(z,normal);
}
