
uniform float rx,ry,rz;
uniform int mirrorx;
varying vec2 texCoord;
varying vec3 normal;
varying vec3 position;
varying vec3 vert;

varying vec3 lightVec; 
varying vec3 eyeVec;
attribute vec3 vTangent; 	
varying vec3 v_position;
vec4 rotateAroundX( float angle, vec4 v )
{
	float sa = sin( angle );
	float ca = cos( angle );

	return vec4( v.x,
				 ca*v.y - sa*v.z,
				 sa*v.y + ca*v.z,
				 v.w );
}

vec4 rotateAroundY( float angle, vec4 v )
{
	float sa = sin( angle );
	float ca = cos( angle );

	return vec4( sa*v.z + ca*v.x,   v.y,
				 ca*v.z - sa*v.x,   v.w );
}

vec4 rotateAroundZ( float angle, vec4 v )
{
	float sa = sin( angle );
	float ca = cos( angle );

	return vec4( ca*v.x - sa*v.y,
				 sa*v.x + ca*v.y,
				 v.z, v.w );
}

void main( void )
{
	gl_FrontColor = gl_Color;
	gl_TexCoord[0] = gl_MultiTexCoord0;
	texCoord= gl_MultiTexCoord0;
	vec4 vertex = rotateAroundX(rx,gl_Vertex);
vertex= rotateAroundY(ry,vertex);
vertex= rotateAroundZ(rz,vertex);
vert = vertex;

	normal = gl_NormalMatrix * gl_Normal;
	position = vec3( gl_ModelViewMatrix * vertex );
	vert=vertex;
	if(mirrorx>=1)
	vertex.x=-vertex.x;

	vec3 n = normalize(gl_NormalMatrix * gl_Normal);
	normal=n;
	vec3 t = normalize(gl_NormalMatrix * vTangent);
	vec3 b = cross(n, t);
	vec3 vVertex = vec3(gl_ModelViewMatrix * gl_Vertex);
	vec3 tmpVec = gl_LightSource[0].position.xyz - vVertex;
	lightVec.x = dot(tmpVec, t);
	lightVec.y = dot(tmpVec, b);
	lightVec.z = dot(tmpVec, n);
	tmpVec = -vVertex;
	eyeVec.x = dot(tmpVec, t);
	eyeVec.y = dot(tmpVec, b);
	eyeVec.z = dot(tmpVec, n);

	gl_Position = gl_ModelViewProjectionMatrix * vertex;

v_position=gl_Position;
}

