#extension GL_EXT_gpu_shader4 : enable

uniform sampler2D Tex;

varying vec2 TexCoord;

void main()
{
	vec4 c = texture2D(Tex, TexCoord) - vec4(.1, .05, 0, 0); // Reduce r & g components (helps with the polaroid feel)

	ivec2 pixelCoord = ivec2(gl_FragCoord.xy);
	if (((pixelCoord.x | pixelCoord.y) & 3) == 0) c -= .2 * TexCoord.y; // Dots

	c.g -= .2 * abs(TexCoord.y - .5) * (.6 + .4 * TexCoord.x); // Gradient
	c -= pow(length(TexCoord - .5) * 1.7, 2.0) * .4; // Vignette

	gl_FragData[0] = c;
}