uniform sampler2D tex0;
uniform sampler2D tex1;
uniform sampler2D tex2;
uniform float logoalpha;
uniform float effecttime;
uniform float logocolorfade;
uniform float logofadeout;
varying vec2 texturecoordinate;

void main(void)
{
	vec4 normal_texel = texture2D(tex0, texturecoordinate);
	vec4 fragment_texel = texture2D(tex1, texturecoordinate);
	vec4 white_texel = texture2D(tex2, texturecoordinate);
	
	float fade = 1.0;//0.5+0.5*sin(effecttime*100.0);//0.5 + 0.5*sin(timer * 100)
	if (effecttime < 0.5)
	{
		white_texel.a *= 0.8 * logoalpha;
	}
	
	float t = min(effecttime * 3.0 * logoalpha, 1.0);
	if (fragment_texel.r > min(t, logofadeout))
		discard;
		
	if (fragment_texel.r > logocolorfade)
		normal_texel = white_texel;
	vec4 finalcolor = mix(white_texel, normal_texel, logocolorfade);
	gl_FragColor = finalcolor * logoalpha * fade;//vec4(normal_texel.rgb, 1);//vec4(normal_texel.rgb, logoalpha);

}