// Vertex shader input structure
struct VS_INPUT
{
    float4 Position   : POSITION;
    float4 Normal     : NORMAL;
    float2 Texture    : TEXCOORD0;
    float4 Tangent    : TANGENT;
    float4 BiTangent  : BINORMAL;
};


// Vertex shader output structure
struct VS_OUTPUT
{
    float4 Position   : POSITION;
    float3 Normal     : TEXCOORD1;
    float2 Texture    : TEXCOORD0;
    float4 Pos	      : TEXCOORD2;
    float3 Tangent    : TEXCOORD3;
    float3 BiTangent  : TEXCOORD4;
    float4 MPos       : TEXCOORD5;
};


// Global variables
float4x4 WorldView;
float4x4 NormalMat;
float4x4 Proj;
float4x4 ModelMat;

VS_OUTPUT vs_main( in VS_INPUT In )
{
    VS_OUTPUT Out;
    float4 mvPos;                     //create an output vertex

    mvPos = mul(In.Position,
                       WorldView);  //apply vertex transformation

    Out.Position = mul(mvPos, Proj);


    Out.Normal = normalize(mul(In.Normal.xyz,(float3x3) NormalMat));
    //Out.Normal = In.Normal.xyz;

    Out.Tangent = (mul(In.Tangent.xyz,(float3x3) NormalMat));

    //Out.Tangent = Out.Tangent - (Out.Normal * Out.Tangent)*Out.Normal;
    Out.Tangent = normalize(Out.Tangent);

    Out.BiTangent = (mul(In.BiTangent.xyz,(float3x3) NormalMat));

    //Out.BiTangent = Out.BiTangent - (Out.Normal * Out.BiTangent)*Out.Normal - (Out.Tangent * Out.BiTangent) * Out.Tangent / (Out.Tangent * Out.Tangent);
    Out.BiTangent = normalize(Out.BiTangent);

    Out.Texture = (In.Texture);
    Out.Pos = mvPos;
    Out.MPos = mul(In.Position, ModelMat);
    return Out;                         //return output vertex
}
