float4x4 World;
float4x4 View;
float4x4 Projection;

float4 ColorLight; 
float4 ColorFull; 

// TODO: add effect parameters here.

Texture DiffuseTexture;

sampler DiffuseTextureSampler = sampler_state { 
	texture = <DiffuseTexture> ;
	magfilter = LINEAR; 
	minfilter = LINEAR; 
	mipfilter=LINEAR;
	AddressU = mirror; 
	AddressV = mirror;
};

Texture LightTexture;

sampler LightTextureSampler = sampler_state { 
	texture = <LightTexture> ;
	magfilter = LINEAR; 
	minfilter = LINEAR; 
	mipfilter=LINEAR;
	AddressU = mirror; 
	AddressV = mirror;
};

struct VertexShaderInput
{
    float4 Position : POSITION;
	float2 TextureCoordinates : TEXCOORD0; 
};

struct VertexShaderOutput
{
    float4 Position : POSITION;
	float2 TextureCoordinates : TEXCOORD0; 
};

VertexShaderOutput VertexShaderFunction(VertexShaderInput input)
{
    VertexShaderOutput output = (VertexShaderOutput)0; 

    float4 worldPosition = mul(input.Position, World);
    float4 viewPosition = mul(worldPosition, View);
    output.Position = mul(viewPosition, Projection);
	output.TextureCoordinates = input.TextureCoordinates;
    return output;
}

float4 PixelShaderFunction(VertexShaderOutput input) : COLOR0
{
    // TODO: add your pixel shader code here.
	float4 base = tex2D(DiffuseTextureSampler, input.TextureCoordinates);
	float4 over = tex2D(LightTextureSampler, input.TextureCoordinates) * ColorLight; 

	float4 output = ColorFull + base + over;  
	// Blending
	//float4 output = over; 

	return output;
}

technique Technique1
{
    pass Pass1
    {
        // TODO: set renderstates here.

        VertexShader = compile vs_2_0 VertexShaderFunction();
        PixelShader = compile ps_2_0 PixelShaderFunction();
    }
}
