using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;

using Core.Clases;

namespace Core
{
    /// <summary>
    /// This is the main type for your game
    /// </summary>
    public class GameMain : Microsoft.Xna.Framework.Game
    {
        GraphicsDeviceManager graphics;
        BasicEffect shader; 
        Camera camera;
        Grid grid;
        ShaderCubeModel cube1;
        Vista modelo; 

        Int32 gy = 0;
        Int32 gx = 0; 

        public GameMain()
        {
            graphics = new GraphicsDeviceManager(this);
            graphics.PreferredBackBufferWidth = 1280;
            graphics.PreferredBackBufferHeight = 720;
            Content.RootDirectory = "Content";
        }

        /// <summary>
        /// Allows the game to perform any initialization it needs to before starting to run.
        /// This is where it can query for any required services and load any non-graphic
        /// related content.  Calling base.Initialize will enumerate through any components
        /// and initialize them as well.
        /// </summary>
        protected override void Initialize()
        {
            // TODO: Add your initialization logic here
            camera = new Camera(new Vector3(0.0f, 2.0f, 2.0f), Vector3.Zero, Vector3.Up, (float)Window.ClientBounds.Width / (float)Window.ClientBounds.Height);
            base.Initialize();
        }

        /// <summary>
        /// LoadContent will be called once per game and is the place to load
        /// all of your content.
        /// </summary>
        protected override void LoadContent()
        {
            GraphicsDevice.BlendState = BlendState.AlphaBlend;
            GraphicsDevice.RasterizerState = new RasterizerState() { CullMode = Microsoft.Xna.Framework.Graphics.CullMode.None }; 
            shader = new BasicEffect(this.GraphicsDevice);
            shader.VertexColorEnabled = true;
            cube1 = new ShaderCubeModel(Content.Load<Model>(@"cube"), 
                                    new EntityEffect(Content.Load<Effect>(@"shaderCube")), 
                                    Content.Load<Texture2D>(@"diffusa"), Content.Load<Texture2D>(@"emision"), null, 
                                    new Vector3( 0.0f, 0.0f, 0.0f ));
            grid = new Grid(this.GraphicsDevice);
            modelo = new Vista();
            modelo.LoadContent(this.Content, "cazador");
            //modelo.world = Matrix.CreateTranslation(2.0f, 0.0f, 0.0f);
        }

        /// <summary>
        /// UnloadContent will be called once per game and is the place to unload
        /// all content.
        /// </summary>
        protected override void UnloadContent()
        {
            // TODO: Unload any non ContentManager content here
        }

        /// <summary>
        /// Allows the game to run logic such as updating the world,
        /// checking for collisions, gathering input, and playing audio.
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        protected override void Update(GameTime gameTime)
        {
            // Allows the game to exit
            if (GamePad.GetState(PlayerIndex.One).Buttons.Back == ButtonState.Pressed)
                this.Exit();

            if (Keyboard.GetState().IsKeyDown(Keys.NumPad4)) 
                gy--;
            if (Keyboard.GetState().IsKeyDown(Keys.NumPad6)) 
                gy++;
            if (Keyboard.GetState().IsKeyDown(Keys.NumPad8)) 
                gx--;
            if (Keyboard.GetState().IsKeyDown(Keys.NumPad2)) 
                gx++;
            
            camera.Rotations(gx, gy);

            shader.World = Matrix.Identity;
            shader.View = camera.view;
            shader.Projection = camera.projection;
            // TODO: Add your update logic here

            base.Update(gameTime);
        }

        /// <summary>
        /// This is called when the game should draw itself.
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        protected override void Draw(GameTime gameTime)
        {
            GraphicsDevice.Clear(Color.Black);
            GraphicsDevice.SetVertexBuffer(grid.vertexBuffer);

            GraphicsDevice.BlendState = BlendState.AlphaBlend;

            foreach (EffectPass pass in shader.CurrentTechnique.Passes)
            {
                pass.Apply();
                GraphicsDevice.DrawUserPrimitives<VertexPositionColor>
                (PrimitiveType.LineList, grid.vertex, 0, grid.vertex.Length / 2);
            }

            //cube1.Draw(camera);
            //GraphicsDevice.RasterizerState.FillMode = FillMode.Solid;
            //modelo.Draw(camera);
            //GraphicsDevice.RasterizerState.FillMode = FillMode.Solid;
            modelo.Draw(camera);
            base.Draw(gameTime);
        }
    }
}
