﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using Microsoft.Xna.Framework; 
using Microsoft.Xna.Framework.Graphics; 
using Microsoft.Xna.Framework.Content; 


namespace Core.Clases
{
    class Vista
    {
        public Matrix world = Matrix.Identity; 
        public Model model;
        public Texture2D diffuse;
        public Texture2D light; 
        public EntityEffect shader;

        public void LoadContent(ContentManager content, String path)
        {
            model = content.Load<Model>(path + "_model");
            diffuse = content.Load<Texture2D>(path + "_diffuse");
            light = content.Load<Texture2D>(path + "_light");
            shader = new EntityEffect( content.Load<Effect>("entityShader"));
            model.Meshes[0].MeshParts[0].Effect = shader; 
        }

        public void Draw(Camera camera)
        {
            Matrix[] transforms = new Matrix[model.Bones.Count];
            model.CopyAbsoluteBoneTransformsTo(transforms);
            foreach (ModelMesh mesh in model.Meshes)
            {
                foreach (EntityEffect be in mesh.Effects)
                {
                    be.DiffuseTexture = diffuse;
                    be.LightTexture = light;
                    be.ColorFull = Color.Black;
                    be.ColorLight = Color.White;  
                    be.Projection = camera.projection;
                    be.View = camera.view;
                    be.World = world*mesh.ParentBone.Transform;
                }
                mesh.Draw();
            }
        }

    }
}
