﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;

namespace Core.Clases
{
    class ShaderCubeModel
    {
        public Model model { get; protected set; }
        public Matrix world = Matrix.Identity;
        public Texture2D difusa;
        public Texture2D emisiva;
        public Texture2D sobre; 

        public ShaderCubeModel(Model m, 
                                Effect e, 
                                Texture2D d, Texture2D te, Texture2D o, Vector3 p)
        {
            difusa = d;
            emisiva = te;
            sobre = o; 
            model = m;
            m.Meshes[0].MeshParts[0].Effect = e; 
            //world = Matrix.CreateTranslation(p);
            world = Matrix.Identity; 
        }

        public void Draw( Camera camera)
        {
            //Matrix[] transforms = new Matrix[model.Bones.Count];
            //model.CopyAbsoluteBoneTransformsTo(transforms);
            foreach (ModelMesh mesh in model.Meshes)
            {
                foreach (CubeEffect effect in mesh.Effects)
                {

                    //CubeEffect effect = shader as CubeEffect;
                    //effect.VertexColorEnabled = false; 
                    //effect.EnableDefaultLighting();
                    //effect.TextureEnabled = true;
                    effect.DiffuseTextureBase = difusa;
                    effect.DiffuseTextureOver = emisiva;
                    effect.Projection = camera.projection;
                    effect.View = camera.view;
                    effect.Color = Color.Yellow;
                    effect.World = world; // *mesh.ParentBone.Transform;
                }
                mesh.Draw();
            }
        }
    }
}
