﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework;

namespace Core.Clases
{
    public class EntityEffect: Effect
    {
        public Texture2D DiffuseTexture
        {
            set { base.Parameters["DiffuseTexture"].SetValue(value); }
        }

        public Texture2D LightTexture
        {
            set { base.Parameters["LightTexture"].SetValue(value); }
        }

        public Matrix World
        {
            set { base.Parameters["World"].SetValue(value); }
        }

        public Matrix View
        {
            set { base.Parameters["View"].SetValue(value); }
        }

        public Matrix Projection
        {
            set { base.Parameters["Projection"].SetValue(value); }
        }

        public Color ColorLight
        {
            set { base.Parameters["ColorLight"].SetValue(value.ToVector4()); }
        }

        public Color ColorFull
        {
            set { base.Parameters["ColorFull"].SetValue(value.ToVector4()); }
        }

        public EntityEffect(Effect _effect)
            :base(_effect )
        {
            base.CurrentTechnique = base.Techniques["Technique1"]; 
        }
    }
}
