﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;

namespace Core.Clases
{
    class CubeModel
    {
        public Model model { get; protected set; }
        public Matrix world = Matrix.Identity;
        public Texture2D texture; 

        public CubeModel(Model m, Texture2D t, Vector3 p)
        {
            texture = t; 
            model = m;
            world = Matrix.CreateTranslation(p);
        }

        public void Draw( Camera camera)
        {
            //Matrix[] transforms = new Matrix[model.Bones.Count];
            //model.CopyAbsoluteBoneTransformsTo(transforms);
            foreach (ModelMesh mesh in model.Meshes)
            {
                foreach (BasicEffect be in mesh.Effects)
                {
                    be.VertexColorEnabled = false; 
                    be.EnableDefaultLighting();
                    be.TextureEnabled = true;
                    be.Texture = texture; 
                    be.Projection = camera.projection;
                    be.View = camera.view;
                    be.World = world;// *mesh.ParentBone.Transform;
                }
                mesh.Draw();
            }
        }
    }
}
