﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework;

namespace Core.Clases
{
    public class CubeEffect: Effect
    {
        public Texture2D DiffuseTextureBase
        {
            set { base.Parameters["BaseTexture"].SetValue(value); }
        }

        public Texture2D DiffuseTextureOver
        {
            set { base.Parameters["OverTexture"].SetValue(value); }
        }

        public Matrix World
        {
            set { base.Parameters["World"].SetValue(value); }
        }

        public Matrix View
        {
            set { base.Parameters["View"].SetValue(value); }
        }

        public Matrix Projection
        {
            set { base.Parameters["Projection"].SetValue(value); }
        }

        public Color Color
        {
            set { base.Parameters["Color"].SetValue(value.ToVector4()); }
        }

        public CubeEffect(Effect _effect)
            :base(_effect )
        {
            base.CurrentTechnique = base.Techniques["Technique1"]; 
        }
    }
}
