﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Xna.Framework;

namespace Core.Clases
{
    public class Camera
    {
        public Matrix view { get; protected set; }
        public Matrix projection { get; protected set; }

        public Vector3 position;
        public Vector3 target;
        public Vector3 up; 

        public Camera( Vector3 position, Vector3 target, Vector3 up, float aspectRatio)
        {
            this.position = position;
            this.target = target;
            this.up = up; 
            view = Matrix.CreateLookAt(position, target, up);
            projection = Matrix.CreatePerspectiveFieldOfView(
            MathHelper.PiOver4, aspectRatio, 1, 100);
        }

        public void Rotations(Int32 gx, Int32 gy)
        {
            Matrix transform = Matrix.CreateFromYawPitchRoll(MathHelper.ToRadians(gy), MathHelper.ToRadians(gx), 0.0f);
            Vector3 pos_transformed = Vector3.Transform(position, transform);
            view = Matrix.CreateLookAt(pos_transformed, target, up);
        }
    }
}
