using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;

using Game.Entidades; 

namespace Game.Servicios
{
    /// <summary>
    /// This is a game component that implements IUpdateable.
    /// </summary>
    public class TransferenciaProcessor : AbstractProcessor
    {
        #region Atributos

        private Transferencia transferencia_jugador_1;
        private Transferencia transferencia_jugador_2; 
        private GameScene Main; 

        #endregion 

        public TransferenciaProcessor(DefaultScene game)
            : base(game)
        {
            this.Main = game as GameScene;
            this.transferencia_jugador_1 = Main.transferencias[(int)PlayerIndex.One];
            this.transferencia_jugador_2 = Main.transferencias[(int)PlayerIndex.Two]; 
        }

        public override void LoadContent()
        {
        }

        public override void UnloadContent()
        {
        }

        public override void Initialize()
        { 
        }

        public override void Update(GameTime gameTime)
        {
            if (transferencia_jugador_1.Actualizar(gameTime.ElapsedGameTime.Milliseconds))
            {
                if (transferencia_jugador_2.TieneSalida)
                {
                    System.Diagnostics.Debug.WriteLine("COLISION -> PL1 {0} -> PL2 {1}", transferencia_jugador_1.TotalCubosSalida, transferencia_jugador_2.TotalCubosSalida);
                    if (transferencia_jugador_2.TotalCubosSalida > transferencia_jugador_1.TotalCubosSalida)
                    {
                        transferencia_jugador_2.Eliminar(transferencia_jugador_1.TotalCubosSalida);
                        transferencia_jugador_1.EliminarTodo();
                    }
                    else
                    {
                        transferencia_jugador_1.Eliminar(transferencia_jugador_2.TotalCubosSalida);
                        transferencia_jugador_2.EliminarTodo();
                    }
                    System.Diagnostics.Debug.WriteLine("COLISION -> PL1 {0} -> PL2 {1}", transferencia_jugador_1.TotalCubosSalida, transferencia_jugador_2.TotalCubosSalida);
                }
            }
            if (transferencia_jugador_2.Actualizar(gameTime.ElapsedGameTime.Milliseconds))
            {
                if (transferencia_jugador_1.TieneSalida)
                {
                    System.Diagnostics.Debug.WriteLine("COLISION -> PL2 {0} -> PL1 {1}", transferencia_jugador_2.TotalCubosSalida, transferencia_jugador_1.TotalCubosSalida);
                    if (transferencia_jugador_1.TotalCubosSalida > transferencia_jugador_2.TotalCubosSalida)
                    {
                        transferencia_jugador_1.Eliminar(transferencia_jugador_2.TotalCubosSalida);
                        transferencia_jugador_2.EliminarTodo();
                    }
                    else
                    {
                        transferencia_jugador_2.Eliminar(transferencia_jugador_1.TotalCubosSalida);
                        transferencia_jugador_1.EliminarTodo();
                    }
                    System.Diagnostics.Debug.WriteLine("COLISION -> PL2 {0} -> PL1 {1}", transferencia_jugador_2.TotalCubosSalida, transferencia_jugador_1.TotalCubosSalida);

                }
            }
        }

        public override void Draw(GameTime gameTime)
        {
        }
    }
}
