﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;

namespace Game.Servicios
{
    public class MusicaService: IDisposable
    {
        SoundEffect musica;
        SoundEffectInstance musicaInstance; 

        public MusicaService(SoundEffect _musica)
        {
            this.musica = _musica; 
        }

        //public void Play()
        //{
        //    musicaInstance = musica.CreateInstance();
        //    musicaInstance.Play();
        //}

        public void Stop()
        {
            if (musicaInstance != null)
            {
                musicaInstance.Stop();
                musicaInstance.Dispose();
                musicaInstance = null;
            }
        }

        public void Update()
        {
            if (musicaInstance != null)
            {
                if (musicaInstance.State != SoundState.Playing)
                {
                    musicaInstance.Play();
                }
            }
            else
            {
                musicaInstance = musica.CreateInstance();
                musicaInstance.Play();
            }
        }


        public void Dispose()
        {
            if (musicaInstance != null) musicaInstance.Dispose();
            musica.Dispose();
        }
    }
}
