﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;

using FontContent; 

namespace Game.Servicios
{
    public class FontBatch
    {
        private SpriteBatch spriteBatch; 
        private Fuente fuente;
        private Texture2D textura;

        private Color colorSombra = new Color(.0f, .0f, .0f, .2f);

        public FontBatch(SpriteBatch _spriteBatch, Fuente _fuente, Texture2D _textura)
        {
            this.spriteBatch = _spriteBatch;
            this.fuente = _fuente;
            this.textura = _textura; 
        }

        public void DrawShadowText(String mensaje, float x, float y, float escala, Color color, float difX, float difY)
        {
            DrawText(mensaje, x+difX, y+difY, escala, new Color( 0.0f, 0.0f, 0.0f, 0.75f));
            DrawText(mensaje, x, y, escala, color);
        }

        public void DrawText(String mensaje, float x, float y, float escala, Color color)
        {
            foreach (char caracter in mensaje)
            {
                Letra? parametros = fuente.ObtenerLetraArea(caracter);
                if (parametros != null)
                {
                    
                    spriteBatch.Begin(SpriteSortMode.Immediate, BlendState.AlphaBlend);
                    spriteBatch.Draw(textura,
                        new Rectangle((int)x, (int)y, (int)(parametros.Value.w * escala), (int)(parametros.Value.h * escala)),
                        new Rectangle(parametros.Value.x, parametros.Value.y, parametros.Value.w, parametros.Value.h), 
                        color);
                    spriteBatch.End();
                    x += (int)(parametros.Value.w * escala);
                }
            }
        }
    }
}
