﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;

namespace Game.Servicios
{
    public class AudioService : IDisposable
    {
        SoundEffect[] sonidos;

        public AudioService(SoundEffect[] _sonidos)
        {
            sonidos = _sonidos;
        }

        public void Play(int refSound)
        {
            SoundEffectInstance sonido = sonidos[refSound].CreateInstance();
            sonido.Play();
        }

        //public void PlayInLoop( int refSound ) {
        //    SoundEffectInstance sonido = sonidos[refSound].CreateInstance();
        //    sonido.IsLooped = true; 
        //    sonido.Play();
        //}

        public SoundEffectInstance this[int refSonido]
        {
            get { return sonidos[refSonido].CreateInstance(); }
        }

        #region Miembros de IDisposable

        public void Dispose()
        {
            foreach (SoundEffect sonido in sonidos)
            {
                sonido.Dispose();
            }
        }

        #endregion
    }
}
