﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Input; 

namespace Game
{
    public static class Parametros
    {
        public const String PARAM_OPCION_SELECCIONADA = "opcion";
        public const String PARAM_IADIFICULTAD_SELECCIONADA = "ia";

        // Referencias de sonidos
        public const int SONIDO_LANZADO = 0;
        public const int SONIDO_COLISION = 1;
        public const int SONIDO_DETONACION = 2;
        public const int SONIDO_RECEPCION = 3;
        public const int SONIDO_PREPARADO = 4;
        public const int SONIDO_FIN = 5; 

        public const int SONIDO_SELECCION = 0;
        public const int SONIDO_OPCION = 1; 

        public const int OPC_PLAYER_VS_CPU = 0;
        public const int OPC_PLAYER_VS_PLAYER = 1;
        public const int OPC_AYUDA = 2;
        //public const int OPC_VIDEO = 3; 
        public const int OPC_SALIDA = 3;

        public const int SUBOPC_AYUDA_CONTROLES = 0;
        public const int SUBOPC_AYUDA_JUEGO = 1;
        public const int SUBOPC_AYUDA_MARCADORES = 2; 


        public static Int32 RESOLUCION_W = 1280;
        public static Int32 RESOLUCION_H = 720;
        public static Boolean FULLSCREEN = true; 

        public static Int32 DETONADOR_TIEMPO = 9999; 

        public static Vector3 TRANS_CENTRADO = new Vector3(-2.5f, 0.0f, -2.5f);
        public static Vector3 TRANS_MATRIZ_IZQUIERDA = new Vector3(-5.0f, 0.0f, 0.0f);
        public static Vector3 TRANS_MATRIZ_DERECHA = new Vector3(5.0f, 0.0f, 0.0f);

        public static int IA_MODO_FACIL = 0;
        public static int IA_MODO_MEDIO = 1;
        public static int IA_MODO_DIFICIL = 2;

        public const int MAX_X = 6;
        public const int MAX_Z = 6;
        public const int MAX_Y = 12;
        public const int START_Y = 15;
        public static float MAX_CUBOS_MATRIX = MAX_X * MAX_Z * MAX_Y;

        public static float JUGADOR_VELOCIDAD_CAIDA = 1.0f / 1000.0f;
        public static float[] IA_VELOCIDAD_CAIDA = {   2.0f / 1000.0f,      // Facil 
                                                       4.0f / 1000.0f,      // Normal
                                                       8.0f / 1000.0f };    // Dificil
        public static float CUBO_VELOCIDAD_CAIDA = 3.0f / 1000.0f;

        // Tiempo maximo para multiplicador en milisegundos
        public static int MSG_MAXIMO_MULTIPLICADOS = 10000; 

        public static int ARRIBA = 0;
        public static int ABAJO = 1;
        public static int IZQUIERDA = 2;
        public static int DERECHA = 3;
        public static int GIRO_IZQUIERDA = 4;
        public static int GIRO_DERECHA = 5;
        public static int DISPARO = 6; 
        public static Keys[,] CONTROLES = {
                                              { Keys.Up, Keys.Down, Keys.Left, Keys.Right, Keys.A, Keys.D, Keys.Space }, 
                                              { Keys.NumPad8, Keys.NumPad5, Keys.NumPad4, Keys.NumPad6, Keys.NumPad7, Keys.NumPad9, Keys.NumPad0 }};


        public static Color[] CUBO_COLORES = {
                                                 new Color( 255, 65, 65 ),              // ROJO
                                                 new Color( 255, 255, 0 ),              // AMARILLO
                                                 new Color( 0,255,0 ),                  // VERDE
                                                 new Color( 0,65,255 )                  // AZUL
                                             };

        public static Color[,] DETONADOR_COLORES = {
                                                       {                                // Tonos de rojo
                                                           new Color(128, 0, 0 ), 
                                                           new Color( 255,0,0 ), 
                                                           new Color( 255,64,64 ), 
                                                           new Color( 255,255,255 )
                                                       },
                                                       {                                // Tonos de amarillo
                                                           new Color( 64, 64, 0 ), 
                                                           new Color( 192, 192, 0 ), 
                                                           new Color( 255, 255, 64 ), 
                                                           new Color( 255,255,255 )
                                                       }, 
                                                       {                                // Tonos de verde
                                                           new Color( 0,128,0 ), 
                                                           new Color( 0,192,0 ), 
                                                           new Color( 0,255,0 ), 
                                                           new Color( 255,255,255 )
                                                       },
                                                       {                                // Tonos de azul
                                                           new Color( 0,0,192 ), 
                                                           new Color( 0,0,255 ), 
                                                           new Color( 0,128,255 ), 
                                                           new Color( 255,255,255 )
                                                       }
                                                   };


    }
}
