using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;


namespace Game.Graficos
{
    /// <summary>
    /// This is a game component that implements IUpdateable.
    /// </summary>
    public class FondoProcessor : AbstractProcessor
    {
        private SpriteBatch spriteBatch;
        private Texture2D fondo;
        private Viewport vista; 

        public FondoProcessor(DefaultScene game, Viewport vista)
            : base(game)
        {
            this.vista = vista; 
            // TODO: Construct any child components here
        }

        /// <summary>
        /// Allows the game component to perform any initialization it needs to before starting
        /// to run.  This is where it can query for any required services and load content.
        /// </summary>
        public override void Initialize()
        {
        }

        public override void LoadContent()
        {
            this.spriteBatch = new SpriteBatch(this.GraphicsDevice);
            this.fondo = Content.Load<Texture2D>(@"fondos/fondo");
        }

        public override void UnloadContent()
        {
        }

        /// <summary>
        /// Allows the game component to update itself.
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        public override void Update(GameTime gameTime)
        {
        }

        public override void Draw(GameTime gameTime)
        {
            GraphicsDevice.Viewport = vista; 
            //RasterizerState render = GraphicsDevice.RasterizerState;
            spriteBatch.Begin(SpriteSortMode.Immediate, BlendState.Opaque);
            spriteBatch.Draw(fondo, new Rectangle( 0,0, vista.Width, vista.Height), Color.White);
            spriteBatch.End();
            //GraphicsDevice.RasterizerState = render;
            GraphicsDevice.DepthStencilState = DepthStencilState.Default;
        }
    }
}
