﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Game.Entidades
{
    public class Transferencia
    {
        private List<int> listaEntrantes = new List<int>();
        private List<int> listaSaliente = new List<int>();
        private int multiplicador;
        private int parcial;
        private int temporizador;

        public int Multiplicador { get { return this.multiplicador; } }
        public int Tiempo { get { return (Parametros.MSG_MAXIMO_MULTIPLICADOS / multiplicador ) - this.temporizador; } }
        public int TotalCubosEntrada { get { return this.listaEntrantes.Count; } }
        public int TotalCubosSalida { get { return this.listaSaliente.Count; } }
        public bool TieneEntrada { get { return this.listaEntrantes.Count > 0; } }
        public bool TieneSalida { get { return this.listaSaliente.Count > 0; } }

        public Transferencia()
        {
            temporizador = 0; 
            multiplicador = 0;
            parcial = 0;
        }

        public void Enviar(Cubo cubo)
        {
            temporizador = 0; 
            if (this.listaEntrantes.Count > 0)
            {
                if (listaEntrantes[listaEntrantes.Count - 1] != cubo.Color)
                {
                    parcial = 0; 
                    multiplicador++; 
                }
            }
            else
            {
                multiplicador = 1;
            }
            for (int cubos = 1; cubos <= multiplicador; cubos++)
            {
                listaEntrantes.Add(cubo.Color);
            }
            parcial++; 
        }

        public int Recibir()
        {
            int color = this.listaSaliente[0];
            this.listaSaliente.RemoveAt(0);
            return color; 
        }

        //public int[] Recibir()
        //{
        //    int[] colores = null; 
        //    if (this.listaSaliente.Count > 0)
        //    {
        //        this.listaSaliente.Reverse();
        //        colores = this.listaSaliente.ToArray<int>();
        //        this.listaSaliente.Clear();
        //    }
        //    return colores;
        //}

        public void Eliminar(int cubos)
        {
            if (cubos < listaSaliente.Count)
            {
                this.listaSaliente.RemoveRange(0, cubos);
            }
            else
            {
                this.listaSaliente.Clear();
            }
        }

        public void EliminarTodo()
        {
            this.listaSaliente.Clear();
        }

        // El método devuelve FALSE si no ha llegado a 0, 
        // y TRUE si ha llegado a 0 y pasan al vector de salida los cubos acumulados. 
        public bool Actualizar(int tiempo)
        {
            bool finalizado = false; 
            if (listaEntrantes.Count > 0)
            {
                temporizador += tiempo;
                if (temporizador >= ( Parametros.MSG_MAXIMO_MULTIPLICADOS / Multiplicador ))
                {
                    temporizador = 0;
                    multiplicador = 0;
                    parcial = 0;
                    listaSaliente.AddRange(listaEntrantes);
                    listaEntrantes.Clear();
                    finalizado = true;  
                }
            }
            return finalizado; 
        }
    }
}
