﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Content; 

namespace Game
{
    public abstract class AbstractProcessor
    {
        private DefaultScene baseScene;

        public GraphicsDevice GraphicsDevice { get { return this.baseScene.GraphicsDevice; } }
        public ContentManager Content { get { return this.baseScene.Content; } }

        public Boolean visible;
        public Boolean enabled; 

        public AbstractProcessor(DefaultScene baseScene)
        {
            this.baseScene = baseScene;
            this.visible = true;
            this.enabled = true; 
        }

        public abstract void Initialize();

        public abstract void LoadContent();

        public abstract void UnloadContent();

        public abstract void Update(GameTime gameTime);

        public abstract void Draw(GameTime gameTime);
    }
}
