using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;

namespace FontContent
{
    public class FontContentTypeReader : ContentTypeReader<Fuente>
    {
        protected override Fuente Read(ContentReader input, Fuente existingInstance)
        {
            Fuente texto = new Fuente();
            int numLetras;

            numLetras = input.ReadInt32();
            texto.minChar = input.ReadInt32();
            texto.maxChar = input.ReadInt32();
            texto.letras = new Letra[numLetras];
            for (int indx = 0; indx < numLetras; indx++)
            {
                int mx = input.ReadInt32();
                int my = input.ReadInt32();
                int lx = input.ReadInt32();
                int ly = input.ReadInt32();
                texto.letras[indx] = new Letra(mx, my, lx, ly);
            }
            return texto;
        }
    }
}
