using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Content.Pipeline;
using Microsoft.Xna.Framework.Content.Pipeline.Graphics;
using Microsoft.Xna.Framework.Content.Pipeline.Processors;
using Microsoft.Xna.Framework.Content.Pipeline.Serialization.Compiler;
using FontContent; 

// TODO: replace this with the type you want to write out.
using TWrite = FontContent.Fuente;

namespace FontContentPipelineExtension
{
    /// <summary>
    /// This class will be instantiated by the XNA Framework Content Pipeline
    /// to write the specified data type into binary .xnb format.
    ///
    /// This should be part of a Content Pipeline Extension Library project.
    /// </summary>
    [ContentTypeWriter]
    public class FontContentTypeWriter : ContentTypeWriter<TWrite>
    {
        protected override void Write(ContentWriter output, TWrite value)
        {
            output.Write(value.letras.Length);
            output.Write(value.minChar);
            output.Write(value.maxChar);
            foreach (Letra letra in value.letras)
            {
                output.Write(letra.x);
                output.Write(letra.y);
                output.Write(letra.w);
                output.Write(letra.h);
            }
        }
        public override string GetRuntimeType(TargetPlatform targetPlatform)
        {
            return typeof(Fuente).AssemblyQualifiedName;
        }
        public override string GetRuntimeReader(TargetPlatform targetPlatform)
        {
            return typeof(FontContentTypeReader).AssemblyQualifiedName;
        }
    }
}
