﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.IO; 
using System.Windows.Forms;

namespace XCubeConfig
{
    public partial class Form1 : Form
    {
        private String ruta = Path.Combine(Application.StartupPath, "config.cfg");
        private Config configuracion = null; 

        public Form1()
        {
            InitializeComponent();
            CargarConfiguracion();
            if (configuracion != null)
            {
                if (configuracion.videoW == 1024 && configuracion.videoH == 768)
                {
                    this.chk1024768.Checked = true;
                }
                else if (configuracion.videoW == 1280 && configuracion.videoH == 720)
                {
                    this.chk1280720.Checked = true;
                }
                this.chkFullScreen.Checked = configuracion.fullScreen;
            }
            else
            {
            }
        }

        private void CargarConfiguracion()
        {
            StreamReader sr = null;
            try
            {
                sr = new StreamReader(new FileStream(ruta, FileMode.Open,  FileAccess.Read));
                configuracion = new Config(sr);
            }
            catch (Exception)
            {
                MessageBox.Show("No se encuentra fichero configuración", "Configuracion", MessageBoxButtons.OK);
            }
            finally
            {
                if (sr != null) sr.Close();
            }
        }

        private void GuardarConfiguracion()
        {
            StreamWriter sw = null;
            try
            {
                sw = new StreamWriter(new FileStream(ruta, FileMode.Create, FileAccess.Write));
                configuracion.Serialize(sw);
                MessageBox.Show("Configuración guardada satisfactoriamente", "Configuración", MessageBoxButtons.OK);
            }
            catch (Exception)
            {
                MessageBox.Show("No se pudo guardar el fichero de configuración", "Configuración", MessageBoxButtons.OK);
            }
            finally
            {
                if (sw != null) sw.Close();
            }
        }

        private void btnGuardar_Click(object sender, EventArgs e)
        {
            if (configuracion != null)
            {
                if (this.chk1024768.Checked)
                {
                    configuracion.videoW = 1024;
                    configuracion.videoH = 768;
                }
                else if (this.chk1280720.CanFocus)
                {
                    configuracion.videoW = 1280;
                    configuracion.videoH = 720;
                }

                configuracion.fullScreen = this.chkFullScreen.Checked;
            }
            else
            {
                if (this.chk1024768.Checked)
                {
                    configuracion = new Config(1024, 768, this.chkFullScreen.Checked);
                }
                else if (this.chk1280720.CanFocus)
                {
                    configuracion = new Config(1024, 768, this.chkFullScreen.Checked);
                }
            }
            GuardarConfiguracion();
        }

        private void btnCancelar_Click(object sender, EventArgs e)
        {
            Application.Exit();
        }
    }
}
