﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO; 

namespace XCubeConfig
{
    class Config
    {
        public int videoW;
        public int videoH;
        public bool fullScreen;

        public Config(int w, int h, bool f)
        {
            this.videoW = w;
            this.videoH = h;
            this.fullScreen = f; 
        }

        public Config(StreamReader sr)
        {
            String fileLine = sr.ReadLine();
            String[] fileData = fileLine.Split(',');
            videoW = Convert.ToInt32(fileData[0]);
            videoH = Convert.ToInt32(fileData[1]);
            fullScreen = Convert.ToBoolean(fileData[2]);
        }

        public void Serialize(StreamWriter sw)
        {
            String fileLine = videoW.ToString() + "," + videoH.ToString() + "," + fullScreen.ToString();
            sw.WriteLine(fileLine);
        }

    }
}
