uniform sampler2D tex0; // suelo
uniform sampler2D tex1; // reflejo
uniform sampler2D tex2; // normal
uniform float bluralpha;
varying vec2 texturecoordinate;

void main(void)
{
	vec3 normal = normalize( texture2D(tex2, texturecoordinate).xyz * 2.0 - 1.0);	
	
	vec4  suelo = texture2D(tex0, texturecoordinate);
	vec2 p = -1.0 + (2.0 * texturecoordinate.xy/8.0);
	float r = 1.0-sqrt(dot(p,p));
	
	vec4 reflex = texture2D(tex1, (gl_FragCoord/vec2(1280.0, 800.0)) + vec2(normal.y, normal.x)*0.1);
	
	
	gl_FragColor = (suelo *1.0 +	reflex * 2.8)*r;

}