/*
 * Decompiled with CFR 0.152.
 */
package processing.xml;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Vector;
import processing.xml.XMLElement;

public class XMLWriter {
    private PrintWriter writer;

    public XMLWriter(Writer writer) {
        this.writer = writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer);
    }

    public XMLWriter(OutputStream stream) {
        this.writer = new PrintWriter(stream);
    }

    protected void finalize() throws Throwable {
        this.writer = null;
        super.finalize();
    }

    public void write(XMLElement xml) throws IOException {
        this.write(xml, false, 0, true);
    }

    public void write(XMLElement xml, boolean prettyPrint) throws IOException {
        this.write(xml, prettyPrint, 0, true);
    }

    public void write(XMLElement xml, boolean prettyPrint, int indent) throws IOException {
        this.write(xml, prettyPrint, indent, true);
    }

    public void write(XMLElement xml, boolean prettyPrint, int indent, boolean collapseEmptyElements) throws IOException {
        if (prettyPrint) {
            int i = 0;
            while (i < indent) {
                this.writer.print(' ');
                ++i;
            }
        }
        if (xml.getLocalName() == null) {
            if (xml.getContent() != null) {
                if (prettyPrint) {
                    this.writeEncoded(xml.getContent().trim());
                    this.writer.println();
                } else {
                    this.writeEncoded(xml.getContent());
                }
            }
        } else {
            String key;
            this.writer.print('<');
            this.writer.print(xml.getName());
            Vector<String> nsprefixes = new Vector<String>();
            if (xml.getNamespace() != null) {
                if (xml.getLocalName().equals(xml.getName())) {
                    this.writer.print(" xmlns=\"" + xml.getNamespace() + '\"');
                } else {
                    String prefix = xml.getName();
                    prefix = prefix.substring(0, prefix.indexOf(58));
                    nsprefixes.addElement(prefix);
                    this.writer.print(" xmlns:" + prefix);
                    this.writer.print("=\"" + xml.getNamespace() + "\"");
                }
            }
            Enumeration<Object> en = xml.enumerateAttributeNames();
            while (en.hasMoreElements()) {
                String prefix;
                String namespace;
                key = en.nextElement();
                int index = key.indexOf(58);
                if (index < 0 || (namespace = xml.getAttributeNamespace(key)) == null || nsprefixes.contains(prefix = key.substring(0, index))) continue;
                this.writer.print(" xmlns:" + prefix);
                this.writer.print("=\"" + namespace + '\"');
                nsprefixes.addElement(prefix);
            }
            en = xml.enumerateAttributeNames();
            while (en.hasMoreElements()) {
                key = en.nextElement();
                String value = xml.getAttribute(key, null);
                this.writer.print(" " + key + "=\"");
                this.writeEncoded(value);
                this.writer.print('\"');
            }
            if (xml.getContent() != null && xml.getContent().length() > 0) {
                this.writer.print('>');
                this.writeEncoded(xml.getContent());
                this.writer.print("</" + xml.getName() + '>');
                if (prettyPrint) {
                    this.writer.println();
                }
            } else if (xml.hasChildren() || !collapseEmptyElements) {
                this.writer.print('>');
                if (prettyPrint) {
                    this.writer.println();
                }
                en = xml.enumerateChildren();
                while (en.hasMoreElements()) {
                    XMLElement child = (XMLElement)en.nextElement();
                    this.write(child, prettyPrint, indent + 4, collapseEmptyElements);
                }
                if (prettyPrint) {
                    int i = 0;
                    while (i < indent) {
                        this.writer.print(' ');
                        ++i;
                    }
                }
                this.writer.print("</" + xml.getName() + ">");
                if (prettyPrint) {
                    this.writer.println();
                }
            } else {
                this.writer.print("/>");
                if (prettyPrint) {
                    this.writer.println();
                }
            }
        }
        this.writer.flush();
    }

    private void writeEncoded(String str) {
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            switch (c) {
                case '\n': {
                    this.writer.print(c);
                    break;
                }
                case '<': {
                    this.writer.print("&lt;");
                    break;
                }
                case '>': {
                    this.writer.print("&gt;");
                    break;
                }
                case '&': {
                    this.writer.print("&amp;");
                    break;
                }
                case '\'': {
                    this.writer.print("&apos;");
                    break;
                }
                case '\"': {
                    this.writer.print("&quot;");
                    break;
                }
                default: {
                    if (c < ' ' || c > '~') {
                        this.writer.print("&#x");
                        this.writer.print(Integer.toString(c, 16));
                        this.writer.print(';');
                        break;
                    }
                    this.writer.print(c);
                }
            }
            ++i;
        }
    }
}

