uniform sampler2D colorMap, blurMap;
uniform float warp,noise,timer;
uniform float exposure;

float noisef(vec2 pos,int seed) {
	float ret = fract(sin(seed+dot(pos,vec2(12.9898,78.233)))*43758.5453)*2.0-0.8;
	return ret;
}

void main() {
	float bloomFactor= 2.0;
	float brightMax= 1.0;

	vec2 offset = vec2(0,0);

	vec4 n;

	if(noise > 0) {
		n.x = noisef(vec2(timer+gl_TexCoord[0].t,gl_TexCoord[0].s),32);
		n.zy = vec2(n.x,n.x);
		n*=noise*0.1;
	}

	
	if(warp > 0) {
		offset.x = sin(gl_TexCoord[0].t*10)*0.01*warp;
		offset.y =  sin(gl_TexCoord[0].s*10)*0.01*warp;
	}
	
	//offset.x += sin(gl_TexCoord[0].t*gl_TexCoord[0].s)*0.1;
	//offset.y +=  sin(gl_TexCoord[0].s*gl_TexCoord[0].s+timer)*0.1;

	vec2 st = gl_TexCoord[0].st+offset;
	vec4 color = texture2D(colorMap, st);
	vec4 colorBloom = texture2D(blurMap, st);

	color += colorBloom * bloomFactor;

	float Y = dot(vec4(0.30, 0.59, 0.11, 0.0), color);
	float YD = exposure * (exposure/brightMax + 1.0) / (exposure + 1.0);
	color *= YD;
	gl_FragData[0] = color+n;
}

