import ddf.minim.*;

Minim minim;
AudioPlayer player;

float MAX_ANGLE_CHANGE = PI / 16;

int MAX_COLOR_CHANGE = 10;
int MAX_SIZE_CHANGE = 5;
int MAX_DISTANCE_CHANGE = 20;
int MAX_SIZE = 80;
int MIN_SIZE = 5;

PImage watermark;

int[] lastColor;
int[] newColor;
int lastSize;
int newSize;
int x;
int y;

float angle;

void setup() {

	lastColor = new int[3];
	newColor = new int[3];

	size(800, 600);
	smooth();

	lastColor[0] = 128;
	lastColor[1] = 128;
	lastColor[2] = 128;

	lastSize = 80;
	x = width / 2;
	y = height / 2;
	angle = PI/2;

	watermark = loadImage("desire.png");

	minim = new Minim(this);
	player = minim.loadFile("africans_are_back.mp3");
	player.play();
}

void draw() {

	if (millis() >= 40000) {
		exit();
	}

	newColor[0] = changeColorValue(lastColor[0]);
	newColor[1] = changeColorValue(lastColor[1]);
	newColor[2] = changeColorValue(lastColor[2]);

	fill(newColor[0], newColor[1], newColor[2]);
	lastColor = newColor;
	
	newSize = changeSizeValue(lastSize);
	lastSize = newSize;

	angle += random(-MAX_ANGLE_CHANGE, MAX_ANGLE_CHANGE);
	x += int(5 * cos(angle));
	y += int(5 * sin(angle));

	if (x > width) {
		x = width;
	} else if (x < 0) {
		x = 0;
	}
	if (y > height) {
		y = height;
	} else if (y < 0) {
		y = 0;
	}

	if (x > (width - 10)) {
		if (y > (height - 10)) {
			angle = PI + PI/4;
		} else if (y < 10) {
			angle = PI - PI/4;
		} else {
			angle = PI;
		}
	} else if (x < 10) {
		if (y > (height - 10)) {
			angle = 2*PI - PI/4;
		} else if (y < 10) {
			angle = PI/4;
		} else {
			angle = 0;
		}
	} else if (y > (height - 10)) {
		angle = PI + PI/2;
	} else if (y < 10) {
		angle = PI/2;
	}

	ellipse(x, y, newSize, newSize);

	image(watermark, width/2, height * 2/3, width/2 - 10, 
		height * 1/3 - 10);
}

void stop() {
	player.close();
	minim.stop();
	super.stop();
}

int changeColorValue(int oldValue) {

	int newValue;

	newValue = oldValue + int(random(-MAX_COLOR_CHANGE, 
		MAX_COLOR_CHANGE));
	if (newValue < 64) {
		newValue = 64;
	} else if (newValue > 255) {
		newValue = 255;
	}

	return newValue;
}

int changeSizeValue(int oldValue) {

	int newValue;

	newValue = oldValue + int(random(-MAX_SIZE_CHANGE, 
		MAX_SIZE_CHANGE));
	if (newValue < MIN_SIZE) {
		newValue = MIN_SIZE;
	} else if (newValue > MAX_SIZE) {
		newValue = MAX_SIZE;
	}

	return newValue;
}
