#ifdef GL_ES
precision highp float;
#endif

uniform float time;
varying vec4 pos;

uniform sampler2D scene1Tex;
uniform sampler2D uSamplerTausta;
uniform sampler2D uSamplerOverlay;
uniform sampler2D bambooTex;
uniform sampler2D spread1Tex;

uniform sampler2D scene2Tex;
uniform sampler2D spread2Tex;
uniform sampler2D water2Tex;

uniform sampler2D tree3Tex;
uniform sampler2D moon3Tex;
uniform sampler2D spread3Tex;

uniform sampler2D chica1Tex;
uniform sampler2D chica2Tex;
uniform sampler2D chica3Tex;

uniform sampler2D credzTex;
uniform sampler2D pmtTex;

uniform sampler2D flower1Tex;
uniform sampler2D flower2Tex;
uniform sampler2D flower3Tex;

uniform sampler2D fallspreadTex;

uniform sampler2D cloud1Tex;

float randd(vec2 co){
    return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);
}

/*
vec4 drawGirl(vec4 c, vec2 coord, vec2 center, float scale) {
	vec2 girlcoord;
	
	vec4 bounds = vec4(center.x - 0.125*scale, center.y - 0.125*scale, center.x + 0.125*scale, center.y + 0.125*scale);
	if (coord.x > bounds.x && coord.y > bounds.y && coord.x < bounds.z && coord.y < bounds.w) {
		girlcoord.y = (coord.y - bounds.y) / (bounds.w - bounds.y);
		girlcoord.x = (coord.x - bounds.x) / (bounds.z - bounds.x);
		vec4 col = texture2D(chica2Tex, girlcoord);
		
		//alpha blending
		col = mix(c, col, col.a);
		return col;
	}	

	return c;
}*/

vec4 drawFlower(vec4 c, vec2 coord, vec2 center, float scale) {
	vec2 texcoord;

	vec4 bounds = vec4(center.x - 0.025*scale, center.y - 0.055*scale, center.x + 0.025*scale, center.y + 0.055*scale);
	if (coord.x > bounds.x && coord.y > bounds.y && coord.x < bounds.z && coord.y < bounds.w) {
		texcoord.y = (coord.y - bounds.y) / (bounds.w - bounds.y);
		texcoord.x = (coord.x - bounds.x) / (bounds.z - bounds.x);
		vec4 col = texture2D(flower1Tex, texcoord);
		
		//alpha blending
		col = mix(c, col, col.a);
		return col;
	}
	
	return c;
}

vec4 drawBamboo(vec4 c, vec2 coord, vec2 p1, vec2 p2, float ttime) {
	vec2 texcoord;

	if (coord.x > p1.x && coord.y > p1.y && coord.x < p2.x && coord.y < p2.y) {
		texcoord.y = (coord.y - p1.y) / (p2.y - p1.y);
		texcoord.x = (coord.x - p1.x) / (p2.x - p1.x) + 0.1*sin(sin(ttime) * texcoord.y) * texcoord.y;
		vec4 col = texture2D(bambooTex, texcoord);
		
		//alpha blending
		col = mix(c, col, col.a);
		
		return col;
	}
	
	return c;
}

//a happy day in a park -scene
vec4 scene1(float ttime) {
	vec4 color;
	float alpha;
	vec2 coord = vec2((pos.x + 1.0)/2.0, (pos.y + 1.0)/2.0);
	
	color.rgb = texture2D(scene1Tex, coord).rgb;

	if (ttime > 5.50) {
		vec4 color2 = color;
		
		if (distance(coord, vec2(0.32, -0.08)) < max(0.0, (ttime - 5.50)) / 2.0)
			color2 = drawBamboo(color2, coord, vec2(0.1, -0.08), vec2(0.22, 0.25), max(0.0, ttime - 5.51));

		if (distance(coord, vec2(0.22, 0.0)) < max(0.0, (ttime - 5.50)) / 2.0)
			color2 = drawBamboo(color2, coord, vec2(0.0, -0.15), vec2(0.12, 0.25), max(0.0, ttime - 5.5));

		if (distance(coord, vec2(0.18, -0.1)) < max(0.0, (ttime - 5.7)) / 2.0)
			color2 = drawBamboo(color2, coord, vec2(0.04, -0.1), vec2(0.16, 0.25), max(0.0, ttime - 5.5));
			
		color = color2;
	}
	
	//flower area border is x>0.63, y<0.24
	if (ttime > 6.6)
		color = drawFlower(color, coord, vec2(0.68, 0.22), min(1.0, ttime - 6.6));
	if (ttime > 6.8)
		color = drawFlower(color, coord, vec2(0.78, 0.12), min(1.0, ttime - 6.6));
	if (ttime > 6.95)
		color = drawFlower(color, coord, vec2(0.69, 0.20), min(1.0, ttime - 6.95));
	if (ttime > 7.05)
		color = drawFlower(color, coord, vec2(0.85, 0.15), min(1.0, ttime - 7.05));
	if (ttime > 7.2)
		color = drawFlower(color, coord, vec2(0.92, 0.02), min(1.0, ttime - 7.2));
	if (ttime > 7.25)
		color = drawFlower(color, coord, vec2(0.72, 0.10), min(1.0, ttime - 7.25));
	if (ttime > 7.4)
		color = drawFlower(color, coord, vec2(0.57, 0.10), min(1.0, ttime - 7.4));

	//draw a cloud
	if (ttime > 9.6) {
		vec2 cloudcoord;
		vec2 ppp1 = vec2(0.55 - (ttime-9.6)*0.05, 0.78);
		vec2 ppp2 = vec2(0.85 - (ttime-9.6)*0.05, 0.97);
//		if (coord.x > ppp1.x && coord.y > ppp1.y && coord.x < ppp2.x && coord.y < ppp2.y) {
			cloudcoord.y = max(0.0, min(1.0, (coord.y - ppp1.y) / (ppp2.y - ppp1.y) + sin(randd(coord) * sin(ttime)) * 0.1));
			cloudcoord.x = max(0.0, min(1.0, (coord.x - ppp1.x) / (ppp2.x - ppp1.x) + sin(randd(coord) * sin(ttime)) * 0.1));
			vec4 colorr = texture2D(pmtTex, cloudcoord);
			color = mix(color, colorr, min(colorr.a, ttime - 9.6));
//		}
	}

/*	if (ttime > 11.0) {
		color = drawGirl(color, coord, vec2(0.5, 0.5), 1.0);
	}*/
		
	alpha = texture2D(uSamplerTausta, coord.xy).r * 1.6;
	
	color.a = alpha;
	if (ttime < 5.75) {
		if (texture2D(spread1Tex, coord.xy).b > ttime/5.0) color.a = 0.0;
		if (texture2D(spread1Tex, coord.xy).b > 0.95 && ttime >= 4.7) color.a = min(alpha, min(1.0, (ttime - 4.7)));
	}
	
	return color;
}

//by a little like -scene
vec4 scene2(float ttime, float ltime) {
	vec4 color;
	float alpha;
	vec2 coord = vec2((pos.x + 1.0)/2.0, (pos.y + 1.0)/2.0);
	

	if (texture2D(water2Tex, coord.xy).b > 0.0) {
		vec2 vesicoord;
		vesicoord.x = coord.x + sin(ttime*sin(coord.y+0.1)*10.0)*0.01;
		vesicoord.y = coord.y;
		color.rgb = texture2D(scene2Tex, vesicoord).rgb;
	} else {
		color.rgb = texture2D(scene2Tex, coord).rgb;
	}
	
			//draw a cloud
	if (ttime > 24.0) {
		vec2 cloudcoord;
		vec2 ppp1 = vec2(0.85 - (ttime-24.0)*0.15, 0.78);
		vec2 ppp2 = vec2(1.35 - (ttime-24.0)*0.15, 0.97);
		cloudcoord.y = max(0.0, min(1.0, (coord.y - ppp1.y) / (ppp2.y - ppp1.y) + sin(randd(coord) * sin(ttime-24.0)) * 0.1));
		cloudcoord.x = max(0.0, min(1.0, (coord.x - ppp1.x) / (ppp2.x - ppp1.x) + sin(randd(coord) * sin(ttime-24.0)) * 0.1));
		vec4 colorr = texture2D(pmtTex, cloudcoord);
		color = mix(color, colorr, min(colorr.a, ttime - 24.0));
	}
	
	alpha = texture2D(uSamplerTausta, coord).r * 1.6;		

	color.a = alpha;

	if (ttime < 24.0) {
		ltime += 1.0;
		if (texture2D(spread2Tex, coord.xy).b > ltime/5.0)
			color = scene1(ttime);
	
			if (texture2D(spread2Tex, coord.xy).b > 0.95 && ltime >= 4.4) {
				vec4 color2 = scene1(ttime);
				
				//alpha blending
				color2.a = min(1.0, (ltime - 4.4));
				color.rgb = color2.rgb + ((color.rgb - color2.rgb) * color2.a);
			}
	}
		
	return color;
}

//black-and-white moon and tree -scene
vec4 scene3(float ttime, float ltime) {
	vec4 color;
	float alpha;
	vec2 coord = vec2((pos.x + 1.0)/2.0, (pos.y + 1.0)/2.0);

	//draw the tree
	vec2 treecoord;
	vec2 p1 = vec2(0.5, 0.0);
	vec2 p2 = vec2(1.0, 0.8);
	if (coord.x > p1.x && coord.y > p1.y && coord.x < p2.x && coord.y < p2.y) {
		treecoord.y = (coord.y - p1.y) / (p2.y - p1.y);
		treecoord.x = (coord.x - p1.x) / (p2.x - p1.x);
		color = texture2D(tree3Tex, treecoord);
		color.rgb = vec3(1.0) - color.rgb;

		//particles \o/
		if (ttime > 36.7) {
			treecoord.y = max(0.0, min(1.0, treecoord.y + sin(ttime - 36.7) * sin(sin((ttime - 36.7)*0.5) * coord.x * randd(coord)) * 1.4));
			vec4 color2 = texture2D(tree3Tex, treecoord);
			color2.rgb = vec3(1.0) - color.rgb;
			color.rgb += color2.a * color2.rgb * min(0.7, ttime - 36.7);
		}
	}

	//draw the moon
	vec2 mooncoord;
	p1 = vec2(0.05, 0.75);
	p2 = vec2(0.15, 0.95);
	if (coord.x > p1.x && coord.y > p1.y && coord.x < p2.x && coord.y < p2.y) {
		mooncoord.y = (coord.y - p1.y) / (p2.y - p1.y);
		mooncoord.x = (coord.x - p1.x) / (p2.x - p1.x);
		color = texture2D(moon3Tex, mooncoord);
	}

	//moon rays
	if (ttime > 35.0) {
		float moontime = ttime - 35.0;
		if (ttime > 36.0) moontime = 36.0-35.0 + sin(ttime - 36.0 * 10.0) * min(time - 36.0, 0.25);
		vec2 asd = vec2(coord.x, -coord.y);
		vec2 bsd = vec2(0.1, 0.95);
		color.rgb += vec3(dot(normalize(coord - asd), normalize(bsd - coord)) * moontime - sin(moontime) * 0.1);
	}
	
	alpha = texture2D(uSamplerTausta, coord).r * 1.6;		
	color.a = alpha;

	//"blending" at the beginning of the scene
	if (ttime < 35.5) {
		if (texture2D(spread3Tex, coord.xy).a == 0.0 || texture2D(spread3Tex, coord.xy).b > ltime/3.5 || texture2D(spread3Tex, coord.xy).g > ltime/3.5) {
			if (coord.x > ltime/2.0)
				color =  scene2(ttime, ttime - 19.24);
		}
		
		if (texture2D(spread3Tex, coord.xy).b > ltime/3.5) {
			if (coord.x > ltime/2.0)
				color =  scene2(ttime, ttime - 19.24);
			else
				color = vec4(0.0, 0.0, 0.0, 1.0);
		}
	}

	return color;
}

//draw a bubble!
vec4 bubble(vec2 bcoord, vec4 c) {
	vec2 coord = vec2((pos.x + 1.0)/2.0, (pos.y + 1.0)/2.0);
	
	if (distance(coord.x, bcoord.x) < 0.0075 && distance(coord.y, bcoord.y) < 0.0075) return vec4(min(1.0, 2.0*c.b));
	
	return c;
}

//I can breath underwater... -scene
vec4 scene4(float ttime, float ltime) {
	vec4 color;
	float alpha;
	vec2 coord = vec2((pos.x + 1.0)/2.0, (pos.y + 1.0)/2.0);

	//background coloring
	vec2 watercoord;
	watercoord.x = sin(coord.x) + sin(ltime * coord.x) * 0.1;
	watercoord.y = sin(coord.y) + sin(ltime * coord.y) * 0.1;

	color.b = watercoord.y * 1.0 + randd(pos.xy) * 0.7;
	color.g = watercoord.y * 1.0 + randd(coord) * 0.3;
	color.a = 1.0;
	
	//bubbles or whatever they are
	for (int i=0; i < 10; i++) {
		color = bubble(
				vec2(
					0.1 + float(i) * 0.1 * randd(vec2(float(i) * 0.1)),// + sin(ltime * 10.0) * 0.01,
					0.0 + ltime * 0.2 * randd(vec2(coord.x + float(i) * 0.1))
				),
				color
			);
	}
		
	//fallspread
	vec2 offset;
	if (ttime > 41.6) {
		if (ttime < 41.9) {
			offset = vec2(0.0, 0.2);
			offset.y = mix(offset.y, 0.05, (ttime-41.7)/(41.9-41.7));
			
			if (texture2D(fallspreadTex, coord).b > 0.0 && texture2D(fallspreadTex, coord).b < (ttime-41.6)*2.5)
				color = vec4(1.0);
		} else {
			offset = vec2(0.0, 0.05);
			offset.y = mix(offset.y, -0.78, min(1.0, (ttime - 41.9)*0.5));
			
			if (texture2D(fallspreadTex, coord).b > 0.0 && texture2D(fallspreadTex, coord).b < 1.0 - (ttime-41.9)*7.5)
				color = vec4(1.0);
		}
		
		//the girl who fell from the sky
		vec4 color2;
		vec2 chicacoord;
		vec2 p1 = vec2(0.60 + offset.x, 0.70 + offset.y);
		vec2 p2 = vec2(0.90 + offset.x, 1.0 + offset.y);
		if (coord.x > p1.x && coord.y > p1.y && coord.x < p2.x && coord.y < p2.y) {
			chicacoord.y = (coord.y - p1.y) / (p2.y - p1.y);
			chicacoord.x = (coord.x - p1.x) / (p2.x - p1.x);
			if (ttime < 43.0)
				color2 = texture2D(chica2Tex, chicacoord);
			else {
				vec4 color3 = texture2D(chica2Tex, chicacoord);
				color2 = texture2D(chica3Tex, chicacoord);
				color2 = mix(color3, color2, min(1.0, ttime - 43.0));
			}
			color = mix(color, color2, color2.a);
		}
	}
	
	vec2 plantcoord;
	vec2 pp1 = vec2(0.0, 0.0);
	vec2 pp2 = vec2(1.0, 0.3);
	if (coord.x > pp1.x && coord.y > pp1.y && coord.x < pp2.x && coord.y < pp2.y) {
		plantcoord.y = (coord.y - pp1.y) / (pp2.y - pp1.y);
		plantcoord.x = (pos.x - pp1.x) / (pp2.x - pp1.x) + 0.1*sin(5.0 * ltime * coord.y);
		vec4 color3 = texture2D(bambooTex, plantcoord);
		color = mix(color, color3, color3.a);
	}

	vec2 kalacoord;
	vec2 ap1;
	vec2 ap2;
	
	for (int j=3; j<15; j++) {
		ap1 = vec2(1.0 + randd(vec2(float(j)*0.05)) - ltime*0.2*float(j)*0.12, randd(vec2(float(j)*0.02)) + sin(float(j)*ltime*0.1)*0.005*float(j));
		ap2 = vec2(1.0 + randd(vec2(float(j)*0.05)) + 0.07 - ltime*0.2*float(j)*0.12, randd(vec2(float(j)*0.02)) + 0.07 + sin(float(j)*ltime*0.1)*0.005*float(j));
		if (coord.x > ap1.x && coord.y > ap1.y && coord.x < ap2.x && coord.y < ap2.y) {
			kalacoord.y = (coord.y - ap1.y) / (ap2.y - ap1.y);
			kalacoord.x = (coord.x - ap1.x) / (ap2.x - ap1.x);
			vec4 color5 = texture2D(water2Tex, kalacoord);
			color = mix(color, color5, color5.a);
		}
	}

	alpha = texture2D(uSamplerTausta, coord).r * 1.6;
	color.a = alpha;
	
	if (texture2D(spread2Tex, coord).b > ltime*0.5) {
		color = scene3(ttime, ttime - 32.0);
	}
	
	return color;
}

//credz and logo
vec4 scene5(float ttime, float ltime) {
	vec4 color;
	float alpha;
	vec2 coord = vec2((pos.x + 1.0)/2.0, (pos.y + 1.0)/2.0);

	color = texture2D(credzTex, coord);
	if (ttime > 47.2) {
		if (ttime > 49.0) {
			if (ttime < 50.0)
				color *= 1.0 - (ttime - 49.0);
			color = mix(color, vec4(1.0, 1.0, 1.0, 1.0), min(1.0, ttime - 49.0));
		}
		color -= texture2D(pmtTex, coord) * min(1.0, ttime - 47.8);
	}

	color.a -= texture2D(uSamplerTausta, coord).r * 0.2;

	return color;
}

void main(void) {
	vec2 coord = vec2((pos.x + 1.0)/2.0, (pos.y + 1.0)/2.0);

	vec4 color;
	if (time > 44.8) {
		color = scene5(time, time-44.8);
	} else if (time > 38.4) {
		color = scene4(time, time-38.4);
	} else if (time > 32.0) {
		color = scene3(time, time-32.0);
	} else if (time > 19.24) {
		color = scene2(time, time-19.24);
	} else
		color = scene1(time);

	//vec4 masmas = texture2D(uSamplerOverlay, coord);
	//color = mix(color, masmas, masmas.a);
	//color.rgb -= masmas.rgb;
	//color = masmas;
		
	gl_FragColor = color;
}