-- input callbacks
keys = { anykey = 0, left = 37, up = 38, right = 39, down = 40, esc = 27, space = 32, enter = 13, a = 65, d = 68, s = 83, w = 87, q = 81, e = 69 }
local keys_down = {}

function key_down(self, key)
	if keys_down[key] then
		return
	end
	keys_down[key] = true
	
	if key == keys.esc then
		window:Close()
	else
		local action_key = active_state.actions[key]
		if action_key then
			action_key()
		end
		local action_anykey = active_state.actions[keys.anykey]
		if action_anykey then
			action_anykey()
		end
	end
end

function key_up(self, key)
	keys_down[key] = false
end

function key_char(self, char)
end

function mouse_move(self, x, y)
end

function mouse_down(self, button, x, y)
	viewsize = dungeon_master:GetViewportSize()
	ui:OnMouseDown( button, { x=x/viewsize.x, y=y/viewsize.y } )
end

function mouse_up(self, button, x, y)
	viewsize = dungeon_master:GetViewportSize()
	ui:OnMouseUp( button, { x=x/viewsize.x, y=y/viewsize.y } )
end

function set_cursor(self, x, y)
end

-- create a custom input class
local input_class = Construct( "TBase", "ClassInfoTable" )
input_class.BaseClass = GetModuleTable().TBase.Object
input_class:Insert( "KeyDown", key_down )
input_class:Insert( "KeyUp", key_up )
input_class:Insert( "KeyChar", key_char )
input_class:Insert( "MouseMove", mouse_move )
input_class:Insert( "MouseDown", mouse_down )
input_class:Insert( "MouseUp", mouse_up )
input_class:Insert( "SetCursor", set_cursor )

-- update callbacks
function update(self, dt)
	ui:Execute()
	active_state:update(dt)
	update_audio_state(dt)
end

function on_party_attacked()
	local index = math.random(1, table.getn(party))
	local member = party[index]
	if math.random() > 0.1 then
		local damage = math.random(5, 7)
		play_sfx( sfx.swish )
		if member.IsDead and member.HP < 0 then
			dungeon_master:Info("Will-o'-wisp hits the corpse of " .. member.Name .. ".")
			play_sfx( sfx.entrails )
		elseif member.IsDead then
			member.HP = member.HP - damage
			dungeon_master:Info("Will-o'-wisp kills " .. member.Name .. " to permanent and untimely DEATH!")
			play_sfx( sfx.entrails )
		elseif member.HP <= damage then
			member.HP = 0
			dungeon_master:CameraShake(0.25)
			dungeon_master:Info("Will-o'-wisp hits a deadly wound to " .. member.Name .. "!")
			play_sfx_id( sfx.death, member.Id )
			member.IsDead = true
		else
			member.HP = member.HP - damage
			dungeon_master:CameraShake(0.15)
			dungeon_master:Info("Will-o'-wisp hits " .. member.Name .. " for " .. damage .. " points!")
			play_sfx( sfx.hit )
		end
	else
		dungeon_master:Info("Will-o'-wisp misses " .. member.Name .. "!")
		play_sfx( sfx.swish )
	end
end

-- create a custom update class
local update_class = Construct( "TBase", "ClassInfoTable" )
update_class.BaseClass = GetModuleTable().TBase.Object
update_class:Insert( "Update", update )
update_class:Insert( "OnPartyAttacked", on_party_attacked )

-- create instances of the input and update classes
input = Construct( "TBase", "Object" )
input:SetInstanceTable( input_class )
update = Construct( "TBase", "Object" )
update:SetInstanceTable( update_class )
