party =
{
	{
		Name = "Timothean",
		HP = 100,
		MaxHP = 100,
		Level = 1,
		MeleeSpeed = 1,
		MeleeSpeed = 15,
		MeleeCooldown = 0,
		Portrait = "Portrait_1",
		Weapon = "his Mighty Hammer",
		MeleeDamage = function(self) return math.random( 30, 130 ) end,
		MeleeSound = "swish_hammer",
		Id = "Timo",
		IsDead = false,
	},
	{
		Name = "Heichen",
		HP = 100,
		MaxHP = 100,
		Level = 1,
		MeleeSpeed = 5,
		MeleeCooldown = 0,
		Portrait = "Portrait_2",
		Weapon = "his sword",
		MeleeDamage = function(self) return math.random( 5, 20 ) end,
		MeleeSound = "swish",
		Id = "Heikki",
		IsDead = false,
	},
	{
		Name = "Tigich",
		HP = 100,
		MaxHP = 100,
		Level = 1,
		MeleeSpeed = 0.5,
		MeleeCooldown = 0,
		Portrait = "Portrait_3",
		Weapon = "his fingers",
		MeleeDamage = function(self) return math.random( 2, 8 ) end,
		MeleeSound = "swish_fingers",
		Id = "Tiki",
		IsDead = false,		
	},
	{
		Name = "Weechon",
		HP = 100,
		MaxHP = 100,
		Level = 1,
		MeleeSpeed = 5,
		MeleeCooldown = 0,
		Portrait = "Portrait_4",
		Weapon = "his whip",
		MeleeDamage = function(self) return math.random( 5, 20 ) end,
		MeleeSound = "swish",
		Id = "Wk",
		IsDead = false,
	},
	{
		Name = "Jarchon",
		HP = 100,
		MaxHP = 100,
		Level = 1,
		MeleeSpeed = 5,
		MeleeCooldown = 0,
		Portrait = "Portrait_5",
		Weapon = "his sword",
		MeleeDamage = function(self) return math.random( 5, 20 ) end,
		MeleeSound = "swish",
		Id = "Jarkko",
		IsDead = false,		
	},
	{
		Name = "Elanah",
		HP = 100,
		MaxHP = 100,
		Level = 1,
		MeleeSpeed = 5,
		MeleeCooldown = 0,
		Portrait = "Portrait_6",
		Weapon = "her torch",
		MeleeDamage = function(self) return math.random( 5, 20 ) end,
		MeleeSound = "swish",
		Id = "Elina",
		IsDead = false,
	},
}

local party_reordered = {}
local num_members = #party
for i = 1, num_members do
	local index = math.random( 1, table.getn( party ) )
	table.insert( party_reordered, party[index] )
	table.remove( party, index )
end

function add_party_member()
	table.insert( party, party_reordered[#party + 1] )
	update_portraits()
	update_buttons()
end

function rest_party()
	for i, v in ipairs( party ) do
		if not v.IsDead then
			v.HP = v.HP + v.MaxHP / 4
			if v.HP > v.MaxHP then
				v.HP = v.MaxHP
			end
		end
	end
end
