level = 0
num_levels = 6

local dead = {}
local new_deaths = {}
local party_alive = {}
function update_deaths()
	new_deaths = {}
	party_alive = {}
	for i, v in ipairs( party ) do
		if v.IsDead and not dead[v] then
			table.insert( new_deaths, v )
			dead[v] = true
		end
		if not v.IsDead then
			table.insert( party_alive, v )
		end
	end
end

function get_names(party)
	local txt = ""
	for i, v in ipairs( party ) do
		if i > 1 then
			if i < #party then
				txt = txt .. ", "
			else
				txt = txt .. " and "
			end
		end
		txt = txt .. v.Name
	end
	return txt
end

function get_plural(party, a, b)
	if #party == 1 then
		return a
	else
		return b
	end
end

function get_pep_talk()
	txt = ""
	if #new_deaths > 0 then
		txt = txt .. "The death of " .. get_names( new_deaths ) .. " still fresh in\n" ..
			"the memory - " .. get_names( party_alive ) .. " " .. get_plural( party_alive, "pushes", "push" ) .. " onwards\n" ..
			"with even stronger conviction!"
	else
		txt = txt .. "Together " .. get_names( party_alive ) .. " continue\n" ..
			"onwards in search of the Monster!"
	end
	return txt
end

function get_mourning()
	local party_dead = {}
	for i, v in ipairs( party ) do
		if v.IsDead then
			table.insert( party_dead, v )
		end
	end
	if #party_dead == 0 then
		return
			"The quest has been a superb success!\n" ..
			"With everyone alive the battle-hardened party of veteran\n" ..
			"adventurers decide to form their own Tribe and celebrate!"
	else
		return
			"Even though " .. get_names( party_dead ) .. "\n" ..
			"did not make it, nobody really cares.\n" ..
			"More fame, fortune and of course beer for the living!\n"
	end	
end

level_texts = {
	titlescreen = function()
		return
			"\n" ..
			"DUNGEON\n" ..
			"by\n" ..
			"The Tribe\n" ..
			"\n" ..
			"WASD moves your party and clicking\n" ..
			"the sword icons swings your weapons.\n" ..
			"Good luck."
	end,
	[1] = function()
		local name = party[1].Name
		return
			"CHAPTER 1\n" .. name .. "'s Journey Begins!\n\n" ..
			"You have wandered into a mysterious dungeon.\n" ..
			"A tale of a great Monster dwelling in here aroused\n" ..
			"your interest last night in the Drunken Dwarves' Beerhouse.\n" ..
			"Still suffering from a case of a mild hangover you\n" ..
			"decide to show everyone how tough you are by\n" ..
			"slaying the Monster!"
	end,
	[2] = function()
		return
			"CHAPTER 2\n" .. party[1].Name .. " meets " .. party[2].Name .. "!\n\n" ..
			"The corridors get even darker as you travel deeper\n" ..
			"and deeper into the dungeon. Yet a bright light shines\n" ..
			"your way in the form of a new companion.\n" ..
			party[2].Name .. " decides to join your party in an effort to\n" ..
			"slay the Monster dwelling in the depths!"
	end,
	[3] = function()
		update_deaths()
		return
			"CHAPTER 3\nThe Journey Continues!\n\n" ..
			"You thought nobody has ever ventured this deep into\n" ..
			"the dungeon. Yet another new companion by the name of\n" ..
			party[3].Name .. " comes along and decides to join your party.\n\n" ..
			get_pep_talk()
	end,
	[4] = function()
		update_deaths()
		return
			"CHAPTER 4\nThe Maze of Ultimate Doom!\n\n" ..
			"\"STOP!\" Someone yells from the darkness while\n" ..
			"swinging " .. party[4].Weapon .. " wildly in the air.\n" ..
			"\"I am " .. party[4].Name .. ". I've been searching for a way\n" ..
			"out of this maze for days. Boy am I glad you came along!\"\n\n" ..
			get_pep_talk()
	end,
	[5] = function()
		update_deaths()
		return
			"CHAPTER 5\nOut of the Maze - Finally!\n\n" .. 
			"You finally make it out of the maze only to\n" ..
			"find yourself in a staircase that seems\n" ..
			"to go on and on forever... Running down the stairs you\n" ..
			"bump into " .. party[5].Name .. " who merrily joins your party!\n\n" ..
			get_pep_talk()
	end,
	[6] = function()
		update_deaths()
		return
			"CHAPTER 6\nThe Stairway to \"Not\" Heaven!\n\n" ..
			"A long long long series of staircases lead you\n" ..
			"deeper and deeper underground. Luckily you meet\n" ..
			"a new companion by the name of " .. party[6].Name .. "\n" ..
			"on the way down. At the end of the stairs you reach\n" ..
			"a lair of somekind. Could the Monster be here??\n\n" ..
			get_pep_talk()
	end,
	[7] = function()
		return
			"THE END\nThe Monster is slain, Hooray!!!\n\n" ..
			get_names( party_alive ) .. " " .. get_plural( party_alive, "has", "have" ) .. "\n" ..
			"shown everyone how it is done! Now it is time to head\n" ..
			"back to the Drunken Dwarves' Beerhouse for another beer,\n" ..
			"another hangover, and another tale!\n\n" ..
			get_mourning()
	end,
	GameOver = function()
		return
			"FAILURE\n\n" ..
			get_names( party ) .. "\n" ..
			get_plural( party, "has", "have" ) .. " been killed to DEATH!\n\n" ..
			"Your quest has ended in an utter failure. And to make\n" ..
			"matters even worse, no-one at the Drunken Dwarves' Beerhouse\n" ..
			"will be praising your heroic deeds. Ever. What a pity..."
	end,
}

-- level character mapping
dungeon_master:AddMapLevelBlock(	string.byte('X'), "cube.mesh", false)
dungeon_master:AddMapLevelMonster(	string.byte('f'), "willowisp", 30, 2.0)
dungeon_master:AddMapLevelMonster(	string.byte('W'), "willowisp", 300, 0.5)
dungeon_master:AddMapLevelMonster(	string.byte('S'), "dragon.mesh", 300, 0.5)
dungeon_master:AddMapLevelExit(		string.byte('/'), "SewerADown.mesh", true, 1)

levels = {
	[1] = 
		"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX" ..
		"X..............................X" ..
		"X..............................X" ..
		"X..............................X" ..
		"X..............................X" ..
		"X..............................X" ..
		"X..............................X" ..
		"X..............................X" ..
		"X..............................X" ..
		"X..............................X" ..
		"X..............................X" ..
		"X..............................X" ..
		"X..............................X" ..
		"X..............................X" ..
		"X..............................X" ..
		"X...........XXXXXXXXXXXXXX.....X" ..
		"X...........X/.f...f.....X.....X" ..
		"X...........XXXX...f...X.X.....X" ..
		"X..............XXXXXXXXX.X.....X" ..
		"X................XXX...X.X.....X" ..
		"X...............XXfXX..XfX.....X" ..
		"X...............Xf..X..X.X.....X" ..
		"X..........XXXXXX...X..X.X.....X" ..
		"X..........X........XX.X.X.....X" ..
		"X..........X.XXXX....X.X.X.....X" ..
		"X..........X.X..X...XX.X.X.....X" ..
		"X..........X.X..XX.XX..X.X.....X" ..
		"X.........XX.XX..X.X...XfX.....X" ..
		"X.........X...X..X.XXXXX.X.....X" ..
		"X.........X...X..X..f....X.....X" ..
		"X.........X.*.X..XXXXXXXXX.....X" ..
		"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
		
	[2] = 
		"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX" ..
		"X....f.........X..........ff../X" ..
		"X.XXXXXXXXXXXX.X.XXXXXXXXXXXXXXX" ..
		"X*X..........X.X.X.............X" ..
		"XXX........XXX.X.XXX...........X" ..
		"X..........Xf..Xf..X...........X" ..
		"X..........X.fXXX..X...........X" ..
		"X..........X....ff.X...........X" ..
		"X..........X....ff.X...........X" ..
		"X..........XXXXXXXXX...........X" ..
		"X..............................X" ..
		"X..............................X" ..
		"X..............................X" ..
		"X..............................X" ..
		"X..............................X" ..
		"X..............................X" ..
		"X..............................X" ..
		"X..............................X" ..
		"X..............................X" ..
		"X..............................X" ..
		"X..............................X" ..
		"X..............................X" ..
		"X..............................X" ..
		"X..............................X" ..
		"X..............................X" ..
		"X..............................X" ..
		"X..............................X" ..
		"X..............................X" ..
		"X..............................X" ..
		"X..............................X" ..
		"X..............................X" ..
		"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",	
		
	[3] = 
		"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX" ..
		"X..................X........fffX" ..
		"X..................X.XXXXXXXXXXX" ..
		"X..................X.X.........X" ..
		"X...............XXXX.XXXX......X" ..
		"X...............X.......X......X" ..
		"X...............X.f...f.X......X" ..
		"X.....XXX.XXX..XX.......XX.....X" ..
		"XXXXXXXfXXXfXXXX....f.f..XXXXXXX" ..
		"XX..f..........f...f.f...f....fX" ..
		"XX.XXXXfXXXfXXXX....f....XXXXXXX" ..
		"XX/X..XXX.XXX.X...........X....X" ..
		"XXXX..........X.f.........X....X" ..
		"X.............XXXXXX.XXXXXX....X" ..
		"X..................X.X.........X" ..
		"X..................X.X.........X" ..
		"X.................XX.XX........X" ..
		"X.................X..fX........X" ..
		"X.................XX.XX........X" ..
		"X.................Xf..X........X" ..
		"X.................XX.XX........X" ..
		"X.................X...X........X" ..
		"X.................XX.XX........X" ..
		"X.................X..fX........X" ..
		"X.................XX.XX........X" ..
		"X..................X.X..XXXXXX.X" ..
		"X..................X.XXXX...fXXX" ..
		"X..................X......f....X" ..
		"X..................XXXXXX....X.X" ..
		"X.......................XXXXXX.X" ..
		"X............................X*X" ..
		"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",	
		
	[4] = 
		"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX" ..
		"X........X.XXX...X.............X" ..
		"X........X.....X.XXXXXX........X" ..
		"XXXXXXXXXX..fX.X....ffX........X" ..
		"X........X.XXX.XXX..X.X........X" ..
		"X.ffXXXffX.X.fff.X..X.X........X" ..
		"X.ffX.X....X.XXX.X.XX.XX.......X" ..
		"X.XXX.XXXXXX.fff.X.Xf.fX.......X" ..
		"X/XXX.X....XXX.XXX.XfX.X.......X" ..
		"XXXXX.XX.....X.X...Xf..X.......X" ..
		"XfX...fXXXXXXX.XXXXXfX.X.......X" ..
		"X...XX..ff.f.......X..fX.......X" ..
		"XfX....XXXXX..X..X.X.X.X.......X" ..
		"XXXXXXXX...X.....X.X..fX.......X" ..
		"X.....XXXXXX..X..X.XXX.X.......X" ..
		"X.....X..........X.....X.......X" ..
		"X.....XXXXXX..X..XXXXX.X.......X" ..
		"X..........X.....X..Xf.X.......X" ..
		"X..........XXX.XXXXXX..X.......X" ..
		"X............XXX.X....fX.......X" ..
		"X..........XXXfXXX..XXXX.......X" ..
		"X..........X...Xf..fX..........X" ..
		"X..........X.XfX.XXXX..........X" ..
		"X..........XfXXX.XXXXX.........X" ..
		"X..........X.........X.........X" ..
		"X..........X..f..fX..X.........X" ..
		"XXXXXXXXXX.XXXXX.XX..X.........X" ..
		"X.....ff.XXXXX.X.XXXXX.........X" ..
		"XX.XXXXX.X...X.X.X.............X" ..
		"X..X...X.X.X.XXX.XXXXX.........X" ..
		"X....X*X...X...f....fX.........X" ..
		"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",				
		
	[5] = 
		"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX" ..
		"X..............................X" ..
		"X..............................X" ..
		"X..............................X" ..
		"X..............................X" ..
		"X..............................X" ..
		"X..............................X" ..
		"X..............................X" ..
		"X........XXXXXXXXXX............X" ..
		"X........X........X............X" ..
		"X........X.XXXXXX.X............X" ..
		"X........X.X...XX.X............X" ..
		"X........X.X*X.XX.X............X" ..
		"X........X.XXX.XX.X............X" ..
		"X........X.....XX.X............X" ..
		"X......X/XXXXXXXX.X............X" ..
		"X......X..........X............X" ..
		"X......XXXXXXXXXXXX............X" ..
		"X..............................X" ..
		"X..............................X" ..
		"X..............................X" ..
		"X..............................X" ..
		"X..............................X" ..
		"X..............................X" ..
		"X..............................X" ..
		"X..............................X" ..
		"X..............................X" ..
		"X..............................X" ..
		"X..............................X" ..
		"X..............................X" ..
		"X..............................X" ..
		"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",	
			
	[6] = 
		"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX" ..
		"X..............................X" ..
		"X..............................X" ..
		"X..............................X" ..
		"X..............................X" ..
		"X..............................X" ..
		"X..............................X" ..
		"X..............................X" ..
		"X..............................X" ..
		"X..........XXXXX...............X" ..
		"X..........XX/XX...............X" ..
		"X..........XXSXX...............X" ..
		"X..........XX.XX...............X" ..
		"X..........XX.XX...............X" ..
		"X..........XX.XX...............X" ..
		"X..........XX.XX...............X" ..
		"X.........XX...XX..............X" ..
		"X........XX.....XX.............X" ..
		"X........XX.....XX.............X" ..
		"X.........XX...XX..............X" ..
		"X..........XX.XX...............X" ..
		"X...........XfX................X" ..
		"X........XXXXfXXXX.............X" ..
		"X........XfffffffX.............X" ..
		"X........XXXXfXXXX.............X" ..
		"X...........X*X................X" ..
		"X...........XXX................X" ..
		"X..............................X" ..
		"X..............................X" ..
		"X..............................X" ..
		"X..............................X" ..
		"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",	
		
	-- empty template for creating new levels
	["empty"] = 
		"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX" ..
		"X..............................X" ..
		"X..............................X" ..
		"X..............................X" ..
		"X..............................X" ..
		"X..............................X" ..
		"X..............................X" ..
		"X..............................X" ..
		"X..............................X" ..
		"X..............................X" ..
		"X..............................X" ..
		"X..............................X" ..
		"X..............................X" ..
		"X..............................X" ..
		"X..............................X" ..
		"X..............................X" ..
		"X..............................X" ..
		"X..............................X" ..
		"X..............................X" ..
		"X..............................X" ..
		"X..............................X" ..
		"X..............................X" ..
		"X..............................X" ..
		"X..............................X" ..
		"X..............................X" ..
		"X..............................X" ..
		"X..............................X" ..
		"X..............................X" ..
		"X..............................X" ..
		"X..............................X" ..
		"X..............................X" ..
		"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",

}
