function create_music(path)
	music_state = music_state or {}
	local music = Construct( "TSound", "Stream" )
	music.Looping = true
	music.Paused = true
	music.Volume = 1
	music:Load( path )
	music:Play()
	table.insert( music_state, music )
	return music
end

function create_sfx(path)
	local effect = Construct( "TSound", "Sample" )
	effect:Load( path )
	return effect
end

function update_audio_state(dt)
	for k, v in pairs( music_state ) do
		if v == active_state.music then
			if v.Paused then
				v.Paused = false
			end
			local volume = v.Volume
			volume = volume + dt * 0.5
			if volume > 1 then
				volume = 1
			end
			v.Volume = volume
		else
			local volume = v.Volume
			volume = volume - dt * 0.5
			if volume < 0 then
				volume = 0
				v.Paused = true
			end
			v.Volume = volume
		end
	end
end

sfx =
{
	swish = { create_sfx( "Data/Audio/huiskis.wav" ), create_sfx( "Data/Audio/swish1.wav" ), create_sfx( "Data/Audio/swish2.wav" ), create_sfx( "Data/Audio/swish3.wav" ),
				create_sfx( "Data/Audio/swish5.wav" ), create_sfx( "Data/Audio/swish6.wav" ) },
	swish_hammer = { create_sfx( "Data/Audio/swish4.wav" ) },
	swish_fingers = { create_sfx( "Data/Audio/huiskis.wav" ) },
	hit = { create_sfx( "Data/Audio/block1.wav" ), create_sfx( "Data/Audio/block2.wav" ), create_sfx( "Data/Audio/block3.wav" ), create_sfx( "Data/Audio/block4.wav" ) },
	level_begin = { create_sfx( "Data/Audio/loot3.wav" ) },
	level_end = { create_sfx( "Data/Audio/snap3.wav" ) },
	death = { Timo = create_sfx( "Data/Audio/timo_dead2.wav" ), Tiki = create_sfx( "Data/Audio/tiki_dead.wav" ), Jarkko = create_sfx( "Data/Audio/jarkko_dead.wav" ), 
				Wk = create_sfx( "Data/Audio/wk_dead.wav" ), Elina = create_sfx( "Data/Audio/elina_dead.wav" ), Heikki = create_sfx( "Data/Audio/heikki_dead.wav" ) },
	entrails = { create_sfx( "Data/Audio/spruit1.wav" ), create_sfx( "Data/Audio/spruit2.wav" ) },
}

function play_sfx(t)
	e = t[math.random( 1, table.getn( t ) )]
	e:Play()
end

function play_sfx_id(t, id)
	t[id]:Play()
end
