#include "shared.inc"

sampler TexDiffuse	: register(s0);

//------------------------------------------------------------------------
void vs(
	float4 position 		: POSITION,
	float2 uv				: TEXCOORD0,
					  
	out float4 oPosition	: POSITION,
	out float3 oUvTime		: TEXCOORD0,	
	out float3 oToEye		: TEXCOORD1,
	out float4 oColor		: COLOR,

	uniform float4x4	worldViewProj,
	uniform float4x4	world,
	uniform float4		eye,
	uniform float4		ambient,
	uniform float		time,
	uniform float4		lightPosition)
{
	oPosition = mul(worldViewProj, position);
	
	float4 worldPos = mul(world, position);
	oToEye = eye.xyz - worldPos.xyz; // world space delta
	oUvTime = float3(uv, time);
	oColor = ambient;
}

//------------------------------------------------------------------------
float4 fs(
	float3 texCoordTime	: TEXCOORD0, 
	float3 toEye		: TEXCOORD1,
	float3 worldNormal	: TEXCOORD2, // tangent-space: tangent
	float4 vertexColor	: COLOR ) : COLOR
{
	const float2 uv = texCoordTime.xy;
	const float time = texCoordTime.z;

	float4 diffuseMapSample = tex2D(TexDiffuse, uv);
	float3 albedo = Ungamma( diffuseMapSample.rgb );
	
	float atten = torch_atten(toEye);

	float4 color;
	color.rgb = Gamma( atten*albedo*torch_light(time) );
	color.a = diffuseMapSample.a;
	
	return color;
}
